#ifndef MATCELL_H
#define MATCELL_H

#include <math.h>
#include <iostream>
#include <opencv2/core/core.hpp>
#include <opencv2/highgui/highgui.hpp>

class MatCell
{
public:
    MatCell();
    MatCell(int nbElements);
    ~MatCell();

    operator cv::Mat_<double>() const;

    void eachAssign( const cv::Mat &m);
    void eachMultiplyRight(const cv::Mat &m);
    void eachMultiplyLeft(const cv::Mat &m);

    friend std::ostream &operator<<(std::ostream &os, const MatCell &A){
        MatCell m = A;
        for (int i = 0; i < m.size(); i++){
            os << m[i] << "\n";
        }
        return os;
    }

    int size(){ return (int)_elements.size();}

    cv::Mat_<double> &operator[] (const int index);
    void add(cv::Mat_<double> mat){ _elements.push_back(mat); }


private:
    cv::Mat toMat();
    std::vector<cv::Mat_<double>> _elements;
};

//std::ostream &operator<<(std::ostream &os, const MatCell &m)
//{
//    return os << (cv::Mat) m;
//}

#endif // MATCELL_H
