#include "matcell.h"

MatCell::MatCell()
{
    _elements.clear();
}

MatCell::MatCell(int nbElements)
{
    _elements.clear();
    _elements = std::vector<cv::Mat_<double>>(nbElements);
}

MatCell::~MatCell()
{

}

void MatCell::eachAssign(const cv::Mat &m)
{
    for (int i = 0; i < (int)_elements.size(); i++)
        _elements[i] = m;
}

void MatCell::eachMultiplyLeft(const cv::Mat &m)
{
    for (int i = 0; i < (int)_elements.size(); i++)
        _elements[i] = m * _elements[i];
}

void MatCell::eachMultiplyRight(const cv::Mat &m)
{
    for (int i = 0; i < (int)_elements.size(); i++)
        _elements[i] = _elements[i] * m;
}

cv::Mat_<double> &MatCell::operator[](const int index)
{
    return _elements[index];
}

cv::Mat MatCell::toMat()
{
    cv::Mat_<double> a;
    for (int i = 0; i < (int)_elements.size(); i++){
        a.push_back(_elements[i]);
    }
    return a;
}

MatCell::operator cv::Mat_<double>() const {
    cv::Mat_<double> a;
    for (int i = 0; i < (int)_elements.size(); i++){
        a.push_back(_elements[i]);
    }
    return a;
}

