#ifndef UTILS_H
#define UTILS_H

#include <iostream>
#include <fstream>

#include <opencv2/opencv.hpp>

#ifndef PI
#define PI       3.141592653589793238462643383279502884L
#endif

namespace util{

void saveFileToMatlab(std::string fileName, cv::Mat a, std::string varName);

double rad2deg(double angRad);
double deg2rad(double angDeg);

void makeNonHomogenious(cv::Mat & m);
void copyMatElementsToVector(const cv::Mat & mat, const cv::Mat & idx, std::vector<double> & vec);
void copyVectorToMatElements(const std::vector<double> & vec, const cv::Mat & idx, cv::Mat & mat);

enum{
    CONCAT_HORIZONTAL,
    CONCAT_VERTICAL,
};
cv::Mat concatenateMat(const std::vector<cv::Mat> & matArray, int method = CONCAT_VERTICAL);

}

#endif // UTILS_H
