#ifndef TRANSFORMATIONS_H
#define TRANSFORMATIONS_H

/*!
    \defgroup transformations Transformations
    \ingroup camera_model Camera Model
    \brief Different definitions for rotations and translations
*/
///@{
///


#include <stdio.h>
#include <iostream>
#include <opencv2/opencv.hpp>

#include <cstdlib>
#include <cmath>

#ifndef PI
#define PI       3.141592653589793238462643383279502884L
#endif

//! Construction and decomprosition of rotation matrices
namespace rotmat{
    void decomposeEulerZYZ(const cv::Mat & R, double & t1, double & rho, double & t2);

    cv::Mat fromCameraMatrixAffine(const cv::Mat & P);
    cv::Mat fromEulerZYZ(double t1, double rho, double t2);
}
///@}
#endif
