# Thème de présentation FEMTO-ST pour LaTeX Beamer

Ce thème Beamer non officiel est basé sur la [nouvelle charte graphique de FEMTO-ST](https://extranet.femto-st.fr/intranet/comm/Modles%20de%20documents/FEMTO_ST_charte-graphique_2022.pdf).

# Téléchargement

Pour une utilisation rapide du projet, il suffit de [télécharger le projet en .zip](https://disc.univ-fcomte.fr/gitlab/paul.breugnot/femtoslides/repository/archive.zip) depuis l'interface GitLab.

Il est également possible de cloner le dépôt avec la commande suivante :

```
git clone -b main https://disc.univ-fcomte.fr/gitlab/paul.breugnot/femtoslides.git
```

# Utilisation

Pour utiliser le thème, il est nécessaire de placer les fichiers `beamercolorthemefemto.sty`, `beamerfontthemefemto.sty` et `beamerthemefemto.sty` et le dossier `img` dans le dossier contenant la présentation, ou à tout autre emplacement du système accessible par LaTeX.

La commande `\usetheme{femto}` permet de charger le thème FEMTO-ST.

```latex
\documentclass{beamer}

\usetheme{femto}

\begin{document}
...
\end{document}
```

Afin d'assurer un rendu correct, la page de titre doit être définie avec la commande suivante :

```latex
\begin{document}

\begin{frame}[plain,c]
\titlepage
\end{frame}

...
\end{document}
```

Le thème est compatible avec le format 16:9, qui peut être obtenu en remplaçant la première ligne par la commande suivante :

```latex
\documentclass[aspectratio=169]{beamer}
```

Le reste de la présentation peut être construit avec les commandes Beamer usuelles.

Voir les fichiers `example.tex` et `example.pdf` pour un exemple de présentation.

# Auteurs

- Paul BREUGNOT - paul.breugnot@univ-fcomte.fr
- Alain Giorgetti - alain.giorgetti@femto-st.fr
