#! /bin/bash

cut -d ";" -f 4 data/*.csv | sort | uniq > data/theme.txt

THEMES=$(cat data/theme.txt | tr "\n" ",")
CATEGORIES=$(grep -o -E "^[^(]*" categorie.txt | sed "s/ $//" | tr "\n" ",")
THEMES=$(echo $THEMES | sed "s/,/\",\"/g" | sed "s/^/\"/" | sed "s/,\"$//")
CATEGORIES=$(echo $CATEGORIES | sed "s/,/\",\"/g" | sed "s/^/\"/" | sed "s/,\"$//")

echo $THEMES > data/csv.theme
echo $CATEGORIES > data/csv.cat

FORMATION=$1
echo -n $FORMATION

echo -n -e " ("
echo -n $(cut -d ";" -f 3 $FORMATION | paste -sd+ | bc)
echo " ECTS)"

> $FORMATION.theme
> $FORMATION.cat

echo -e "\tPar thème"

IFS=''
cat data/theme.txt |
while read THEME
do
    echo -n -e "\t\t$THEME "
    ECTS=$(grep $THEME$ $FORMATION | cut -d ";" -f 3)
    if [[ -z "$ECTS" ]]
    then
        ECTS=0
    fi
    ECTS=$(echo $ECTS | tr ' ' '\n' | paste -sd+ | bc)
    THEMES_ECTS=$THEMES_ECTS,$ECTS
    echo -n "$ECTS," >> $FORMATION.theme
    echo $ECTS
done
sed -i "s/,$/\n/" $FORMATION.theme

echo -e "\tPar catégorie"

IFS=''
cat categorie.txt |
while read CAT
do
    CATEGORIE=$(echo $CAT | grep -o -E "^[^(]*")
    PATT=$(echo $CAT | grep -o "(.*)")
    echo -n -e "\t\t$CATEGORIE"
    ECTS=$(grep -E $PATT$ $FORMATION | cut -d ";" -f 3 | paste -sd+ | bc)
    echo -n "$ECTS," >> $FORMATION.cat
    echo $ECTS
done
sed -i "s/,$/\n/" $FORMATION.cat
