#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define N 1000000000

int main (int argc, char** argv)
{
    int task_id;
    int total_tasks;
    long long int n;
    long long int i;

    double l_sum, x, h;

    n=N;

    if(argc<3)
    {
        fprintf(stderr,"Usage : %s task_id total_tasks [n]\n",argv[0]);
        exit(0);
    }

    task_id = atoi(argv[1]);
    total_tasks = atoi(argv[2]);
    
    if(argc==4)
    {
        n = atoll(argv[3]);
    }

    fprintf(stderr, "task_id=%d total_tasks=%d n=%lld\n", task_id, total_tasks, n);

    h = 1.0/n;

    l_sum = 0.0;

    for (i = task_id; i < n; i += total_tasks)
    {
        x = (i + 0.5)*h;
        l_sum += 4.0/(1.0 + x*x);
    }

    l_sum *= h;

    printf("Pi=%0.20g\n", l_sum);

    return 0;
}
