#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <omp.h>

#define N 1000000000

int main (int argc, char** argv)
{
    long long int n;
    long long int i;

    double l_sum, x, h;

    n=N;

    if(argc==2)
    {
       n=atoll(argv[1]);
    }


    h = 1.0/n;

    l_sum = 0.0;

#pragma omp parallel for private(i,x) reduction(+:l_sum)    
    for (i = 0; i < n; i ++)
    {
        x = (i + 0.5)*h;
        l_sum += 4.0/(1.0 + x*x);
    }

    l_sum *= h;

    printf("N=%lld,PI=%0.20g\n",n, l_sum);

    return 0;
}
