#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include <mpi.h>
#define N 1000000000

int main (int argc, char** argv)
{
    int rank;
    int size;
    long long int n;
    long long int i;

    double l_sum,total_sum, x, h;

    MPI_Init(NULL, NULL);
   
    MPI_Comm_size(MPI_COMM_WORLD, &size);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    
    n=N;

    if(rank==0)
    {
        if(argc==2)
        {
         n = atol(argv[1]);
        }

        printf("MPI version with process = %d\n", size);
        printf("Number of intervals: %lld\n", n);
    }


  MPI_Bcast(&n, 1, MPI_LONG, 0, MPI_COMM_WORLD);
    

    h = 1.0/n;

    l_sum = 0.0;

    for (i = rank; i < n; i += size)
    {
        x = (i + 0.5)*h;
        l_sum += 4.0/(1.0 + x*x);
    }

    l_sum *= h;

    MPI_Reduce(&l_sum,&total_sum,1,MPI_DOUBLE,MPI_SUM,0,MPI_COMM_WORLD);
    
    if(rank==0)
    {
        printf("Pi=%0.20g\n", total_sum);

    }

    MPI_Finalize();
    return 0;
}
