/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl;

import fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Function;
import fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement;
import fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.VhdlamsPackage;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Sequential Statement</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.SequentialStatementImpl#getOwnerFunction <em>Owner Function</em>}</li>
 *   <li>{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.SequentialStatementImpl#getOwnerProcess <em>Owner Process</em>}</li>
 *   <li>{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.SequentialStatementImpl#getSequentialStatement <em>Sequential Statement</em>}</li>
 *   <li>{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.SequentialStatementImpl#getOwnerSequentialStatement <em>Owner Sequential Statement</em>}</li>
 *   <li>{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.SequentialStatementImpl#getPredecessor <em>Predecessor</em>}</li>
 *   <li>{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.SequentialStatementImpl#getSuccessor <em>Successor</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class SequentialStatementImpl extends StatementImpl implements SequentialStatement {
	/**
	 * The cached value of the '{@link #getSequentialStatement() <em>Sequential Statement</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSequentialStatement()
	 * @generated
	 * @ordered
	 */
	protected EList<SequentialStatement> sequentialStatement;

	/**
	 * The cached value of the '{@link #getPredecessor() <em>Predecessor</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPredecessor()
	 * @generated
	 * @ordered
	 */
	protected SequentialStatement predecessor;
	/**
	 * The cached value of the '{@link #getSuccessor() <em>Successor</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSuccessor()
	 * @generated
	 * @ordered
	 */
	protected SequentialStatement successor;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SequentialStatementImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return VhdlamsPackage.Literals.SEQUENTIAL_STATEMENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Function getOwnerFunction() {
		if (eContainerFeatureID() != VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_FUNCTION) return null;
		return (Function)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetOwnerFunction(Function newOwnerFunction, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newOwnerFunction, VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_FUNCTION, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOwnerFunction(Function newOwnerFunction) {
		if (newOwnerFunction != eInternalContainer() || (eContainerFeatureID() != VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_FUNCTION && newOwnerFunction != null)) {
			if (EcoreUtil.isAncestor(this, newOwnerFunction))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newOwnerFunction != null)
				msgs = ((InternalEObject)newOwnerFunction).eInverseAdd(this, VhdlamsPackage.FUNCTION__SEQUENTIAL_STATEMENT, Function.class, msgs);
			msgs = basicSetOwnerFunction(newOwnerFunction, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_FUNCTION, newOwnerFunction, newOwnerFunction));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Process getOwnerProcess() {
		if (eContainerFeatureID() != VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_PROCESS) return null;
		return (fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Process)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetOwnerProcess(fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Process newOwnerProcess, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newOwnerProcess, VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_PROCESS, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOwnerProcess(fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Process newOwnerProcess) {
		if (newOwnerProcess != eInternalContainer() || (eContainerFeatureID() != VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_PROCESS && newOwnerProcess != null)) {
			if (EcoreUtil.isAncestor(this, newOwnerProcess))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newOwnerProcess != null)
				msgs = ((InternalEObject)newOwnerProcess).eInverseAdd(this, VhdlamsPackage.PROCESS__SEQUENTIAL_STATEMENT, fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Process.class, msgs);
			msgs = basicSetOwnerProcess(newOwnerProcess, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_PROCESS, newOwnerProcess, newOwnerProcess));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<SequentialStatement> getSequentialStatement() {
		if (sequentialStatement == null) {
			sequentialStatement = new EObjectContainmentWithInverseEList<SequentialStatement>(SequentialStatement.class, this, VhdlamsPackage.SEQUENTIAL_STATEMENT__SEQUENTIAL_STATEMENT, VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_SEQUENTIAL_STATEMENT);
		}
		return sequentialStatement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SequentialStatement getOwnerSequentialStatement() {
		if (eContainerFeatureID() != VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_SEQUENTIAL_STATEMENT) return null;
		return (SequentialStatement)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetOwnerSequentialStatement(SequentialStatement newOwnerSequentialStatement, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newOwnerSequentialStatement, VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_SEQUENTIAL_STATEMENT, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOwnerSequentialStatement(SequentialStatement newOwnerSequentialStatement) {
		if (newOwnerSequentialStatement != eInternalContainer() || (eContainerFeatureID() != VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_SEQUENTIAL_STATEMENT && newOwnerSequentialStatement != null)) {
			if (EcoreUtil.isAncestor(this, newOwnerSequentialStatement))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newOwnerSequentialStatement != null)
				msgs = ((InternalEObject)newOwnerSequentialStatement).eInverseAdd(this, VhdlamsPackage.SEQUENTIAL_STATEMENT__SEQUENTIAL_STATEMENT, SequentialStatement.class, msgs);
			msgs = basicSetOwnerSequentialStatement(newOwnerSequentialStatement, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_SEQUENTIAL_STATEMENT, newOwnerSequentialStatement, newOwnerSequentialStatement));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SequentialStatement getPredecessor() {
		if (predecessor != null && predecessor.eIsProxy()) {
			InternalEObject oldPredecessor = (InternalEObject)predecessor;
			predecessor = (SequentialStatement)eResolveProxy(oldPredecessor);
			if (predecessor != oldPredecessor) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, VhdlamsPackage.SEQUENTIAL_STATEMENT__PREDECESSOR, oldPredecessor, predecessor));
			}
		}
		return predecessor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SequentialStatement basicGetPredecessor() {
		return predecessor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetPredecessor(SequentialStatement newPredecessor, NotificationChain msgs) {
		SequentialStatement oldPredecessor = predecessor;
		predecessor = newPredecessor;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, VhdlamsPackage.SEQUENTIAL_STATEMENT__PREDECESSOR, oldPredecessor, newPredecessor);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPredecessor(SequentialStatement newPredecessor) {
		if (newPredecessor != predecessor) {
			NotificationChain msgs = null;
			if (predecessor != null)
				msgs = ((InternalEObject)predecessor).eInverseRemove(this, VhdlamsPackage.SEQUENTIAL_STATEMENT__SUCCESSOR, SequentialStatement.class, msgs);
			if (newPredecessor != null)
				msgs = ((InternalEObject)newPredecessor).eInverseAdd(this, VhdlamsPackage.SEQUENTIAL_STATEMENT__SUCCESSOR, SequentialStatement.class, msgs);
			msgs = basicSetPredecessor(newPredecessor, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VhdlamsPackage.SEQUENTIAL_STATEMENT__PREDECESSOR, newPredecessor, newPredecessor));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SequentialStatement getSuccessor() {
		if (successor != null && successor.eIsProxy()) {
			InternalEObject oldSuccessor = (InternalEObject)successor;
			successor = (SequentialStatement)eResolveProxy(oldSuccessor);
			if (successor != oldSuccessor) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, VhdlamsPackage.SEQUENTIAL_STATEMENT__SUCCESSOR, oldSuccessor, successor));
			}
		}
		return successor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SequentialStatement basicGetSuccessor() {
		return successor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSuccessor(SequentialStatement newSuccessor, NotificationChain msgs) {
		SequentialStatement oldSuccessor = successor;
		successor = newSuccessor;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, VhdlamsPackage.SEQUENTIAL_STATEMENT__SUCCESSOR, oldSuccessor, newSuccessor);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSuccessor(SequentialStatement newSuccessor) {
		if (newSuccessor != successor) {
			NotificationChain msgs = null;
			if (successor != null)
				msgs = ((InternalEObject)successor).eInverseRemove(this, VhdlamsPackage.SEQUENTIAL_STATEMENT__PREDECESSOR, SequentialStatement.class, msgs);
			if (newSuccessor != null)
				msgs = ((InternalEObject)newSuccessor).eInverseAdd(this, VhdlamsPackage.SEQUENTIAL_STATEMENT__PREDECESSOR, SequentialStatement.class, msgs);
			msgs = basicSetSuccessor(newSuccessor, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VhdlamsPackage.SEQUENTIAL_STATEMENT__SUCCESSOR, newSuccessor, newSuccessor));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_FUNCTION:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetOwnerFunction((Function)otherEnd, msgs);
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_PROCESS:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetOwnerProcess((fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Process)otherEnd, msgs);
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__SEQUENTIAL_STATEMENT:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getSequentialStatement()).basicAdd(otherEnd, msgs);
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_SEQUENTIAL_STATEMENT:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetOwnerSequentialStatement((SequentialStatement)otherEnd, msgs);
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__PREDECESSOR:
				if (predecessor != null)
					msgs = ((InternalEObject)predecessor).eInverseRemove(this, VhdlamsPackage.SEQUENTIAL_STATEMENT__SUCCESSOR, SequentialStatement.class, msgs);
				return basicSetPredecessor((SequentialStatement)otherEnd, msgs);
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__SUCCESSOR:
				if (successor != null)
					msgs = ((InternalEObject)successor).eInverseRemove(this, VhdlamsPackage.SEQUENTIAL_STATEMENT__PREDECESSOR, SequentialStatement.class, msgs);
				return basicSetSuccessor((SequentialStatement)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_FUNCTION:
				return basicSetOwnerFunction(null, msgs);
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_PROCESS:
				return basicSetOwnerProcess(null, msgs);
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__SEQUENTIAL_STATEMENT:
				return ((InternalEList<?>)getSequentialStatement()).basicRemove(otherEnd, msgs);
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_SEQUENTIAL_STATEMENT:
				return basicSetOwnerSequentialStatement(null, msgs);
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__PREDECESSOR:
				return basicSetPredecessor(null, msgs);
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__SUCCESSOR:
				return basicSetSuccessor(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_FUNCTION:
				return eInternalContainer().eInverseRemove(this, VhdlamsPackage.FUNCTION__SEQUENTIAL_STATEMENT, Function.class, msgs);
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_PROCESS:
				return eInternalContainer().eInverseRemove(this, VhdlamsPackage.PROCESS__SEQUENTIAL_STATEMENT, fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Process.class, msgs);
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_SEQUENTIAL_STATEMENT:
				return eInternalContainer().eInverseRemove(this, VhdlamsPackage.SEQUENTIAL_STATEMENT__SEQUENTIAL_STATEMENT, SequentialStatement.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_FUNCTION:
				return getOwnerFunction();
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_PROCESS:
				return getOwnerProcess();
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__SEQUENTIAL_STATEMENT:
				return getSequentialStatement();
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_SEQUENTIAL_STATEMENT:
				return getOwnerSequentialStatement();
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__PREDECESSOR:
				if (resolve) return getPredecessor();
				return basicGetPredecessor();
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__SUCCESSOR:
				if (resolve) return getSuccessor();
				return basicGetSuccessor();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_FUNCTION:
				setOwnerFunction((Function)newValue);
				return;
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_PROCESS:
				setOwnerProcess((fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Process)newValue);
				return;
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__SEQUENTIAL_STATEMENT:
				getSequentialStatement().clear();
				getSequentialStatement().addAll((Collection<? extends SequentialStatement>)newValue);
				return;
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_SEQUENTIAL_STATEMENT:
				setOwnerSequentialStatement((SequentialStatement)newValue);
				return;
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__PREDECESSOR:
				setPredecessor((SequentialStatement)newValue);
				return;
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__SUCCESSOR:
				setSuccessor((SequentialStatement)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_FUNCTION:
				setOwnerFunction((Function)null);
				return;
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_PROCESS:
				setOwnerProcess((fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Process)null);
				return;
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__SEQUENTIAL_STATEMENT:
				getSequentialStatement().clear();
				return;
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_SEQUENTIAL_STATEMENT:
				setOwnerSequentialStatement((SequentialStatement)null);
				return;
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__PREDECESSOR:
				setPredecessor((SequentialStatement)null);
				return;
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__SUCCESSOR:
				setSuccessor((SequentialStatement)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_FUNCTION:
				return getOwnerFunction() != null;
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_PROCESS:
				return getOwnerProcess() != null;
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__SEQUENTIAL_STATEMENT:
				return sequentialStatement != null && !sequentialStatement.isEmpty();
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__OWNER_SEQUENTIAL_STATEMENT:
				return getOwnerSequentialStatement() != null;
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__PREDECESSOR:
				return predecessor != null;
			case VhdlamsPackage.SEQUENTIAL_STATEMENT__SUCCESSOR:
				return successor != null;
		}
		return super.eIsSet(featureID);
	}

} //SequentialStatementImpl
