/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.VhdlamsFactory
 * @model kind="package"
 * @generated
 */
public interface VhdlamsPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "vhdlams";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.femto-st.fr/disc/vhdlams.ecore";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "vhdlams";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	VhdlamsPackage eINSTANCE = fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl.init();

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ElementImpl <em>Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ElementImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getElement()
	 * @generated
	 */
	int ELEMENT = 3;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT__COMMENT = 0;

	/**
	 * The number of structural features of the '<em>Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.DesignUnitImpl <em>Design Unit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.DesignUnitImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getDesignUnit()
	 * @generated
	 */
	int DESIGN_UNIT = 1;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESIGN_UNIT__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESIGN_UNIT__NAME = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESIGN_UNIT__OWNER = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Design Unit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESIGN_UNIT_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ComponentImpl <em>Component</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ComponentImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getComponent()
	 * @generated
	 */
	int COMPONENT = 4;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__COMMENT = DESIGN_UNIT__COMMENT;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__NAME = DESIGN_UNIT__NAME;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__OWNER = DESIGN_UNIT__OWNER;

	/**
	 * The feature id for the '<em><b>Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__PROPERTY = DESIGN_UNIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Statement</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__STATEMENT = DESIGN_UNIT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Component</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_FEATURE_COUNT = DESIGN_UNIT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.EntityImpl <em>Entity</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.EntityImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getEntity()
	 * @generated
	 */
	int ENTITY = 0;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__COMMENT = COMPONENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__NAME = COMPONENT__NAME;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__OWNER = COMPONENT__OWNER;

	/**
	 * The feature id for the '<em><b>Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__PROPERTY = COMPONENT__PROPERTY;

	/**
	 * The feature id for the '<em><b>Statement</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__STATEMENT = COMPONENT__STATEMENT;

	/**
	 * The feature id for the '<em><b>Architecture</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__ARCHITECTURE = COMPONENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Entity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_FEATURE_COUNT = COMPONENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ArchitectureImpl <em>Architecture</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ArchitectureImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getArchitecture()
	 * @generated
	 */
	int ARCHITECTURE = 2;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARCHITECTURE__COMMENT = COMPONENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARCHITECTURE__NAME = COMPONENT__NAME;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARCHITECTURE__OWNER = COMPONENT__OWNER;

	/**
	 * The feature id for the '<em><b>Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARCHITECTURE__PROPERTY = COMPONENT__PROPERTY;

	/**
	 * The feature id for the '<em><b>Statement</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARCHITECTURE__STATEMENT = COMPONENT__STATEMENT;

	/**
	 * The feature id for the '<em><b>Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARCHITECTURE__ENTITY = COMPONENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Architecture</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARCHITECTURE_FEATURE_COUNT = COMPONENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.PackageImpl <em>Package</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.PackageImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getPackage()
	 * @generated
	 */
	int PACKAGE = 5;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__COMMENT = DESIGN_UNIT__COMMENT;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__NAME = DESIGN_UNIT__NAME;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__OWNER = DESIGN_UNIT__OWNER;

	/**
	 * The feature id for the '<em><b>Design Unit</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__DESIGN_UNIT = DESIGN_UNIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Owner Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__OWNER_MODEL = DESIGN_UNIT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Package</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_FEATURE_COUNT = DESIGN_UNIT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VAModelImpl <em>VA Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VAModelImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getVAModel()
	 * @generated
	 */
	int VA_MODEL = 6;

	/**
	 * The feature id for the '<em><b>Package</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VA_MODEL__PACKAGE = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VA_MODEL__NAME = 1;

	/**
	 * The feature id for the '<em><b>Library</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VA_MODEL__LIBRARY = 2;

	/**
	 * The number of structural features of the '<em>VA Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VA_MODEL_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.CommentImpl <em>Comment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.CommentImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getComment()
	 * @generated
	 */
	int COMMENT = 7;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMENT__COMMENT = DESIGN_UNIT__COMMENT;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMENT__NAME = DESIGN_UNIT__NAME;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMENT__OWNER = DESIGN_UNIT__OWNER;

	/**
	 * The feature id for the '<em><b>Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMENT__ELEMENT = DESIGN_UNIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMENT__DESCRIPTION = DESIGN_UNIT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Comment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMENT_FEATURE_COUNT = DESIGN_UNIT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.PropertyImpl <em>Property</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.PropertyImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getProperty()
	 * @generated
	 */
	int PROPERTY = 8;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__NAME = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__OWNER = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__TYPE = ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Default</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__DEFAULT = ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.PortImpl <em>Port</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.PortImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getPort()
	 * @generated
	 */
	int PORT = 9;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT__COMMENT = PROPERTY__COMMENT;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT__NAME = PROPERTY__NAME;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT__OWNER = PROPERTY__OWNER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT__TYPE = PROPERTY__TYPE;

	/**
	 * The feature id for the '<em><b>Default</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT__DEFAULT = PROPERTY__DEFAULT;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT__DIRECTION = PROPERTY_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Port</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT_FEATURE_COUNT = PROPERTY_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.TerminalImpl <em>Terminal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.TerminalImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getTerminal()
	 * @generated
	 */
	int TERMINAL = 10;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERMINAL__COMMENT = PORT__COMMENT;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERMINAL__NAME = PORT__NAME;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERMINAL__OWNER = PORT__OWNER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERMINAL__TYPE = PORT__TYPE;

	/**
	 * The feature id for the '<em><b>Default</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERMINAL__DEFAULT = PORT__DEFAULT;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERMINAL__DIRECTION = PORT__DIRECTION;

	/**
	 * The number of structural features of the '<em>Terminal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERMINAL_FEATURE_COUNT = PORT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.SignalImpl <em>Signal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.SignalImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getSignal()
	 * @generated
	 */
	int SIGNAL = 11;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNAL__COMMENT = PORT__COMMENT;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNAL__NAME = PORT__NAME;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNAL__OWNER = PORT__OWNER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNAL__TYPE = PORT__TYPE;

	/**
	 * The feature id for the '<em><b>Default</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNAL__DEFAULT = PORT__DEFAULT;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNAL__DIRECTION = PORT__DIRECTION;

	/**
	 * The number of structural features of the '<em>Signal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNAL_FEATURE_COUNT = PORT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.QuantityPortImpl <em>Quantity Port</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.QuantityPortImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getQuantityPort()
	 * @generated
	 */
	int QUANTITY_PORT = 12;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_PORT__COMMENT = PORT__COMMENT;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_PORT__NAME = PORT__NAME;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_PORT__OWNER = PORT__OWNER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_PORT__TYPE = PORT__TYPE;

	/**
	 * The feature id for the '<em><b>Default</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_PORT__DEFAULT = PORT__DEFAULT;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_PORT__DIRECTION = PORT__DIRECTION;

	/**
	 * The number of structural features of the '<em>Quantity Port</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_PORT_FEATURE_COUNT = PORT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.TypeImpl <em>Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.TypeImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getType()
	 * @generated
	 */
	int TYPE = 13;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE__COMMENT = DESIGN_UNIT__COMMENT;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE__NAME = DESIGN_UNIT__NAME;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE__OWNER = DESIGN_UNIT__OWNER;

	/**
	 * The number of structural features of the '<em>Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_FEATURE_COUNT = DESIGN_UNIT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ConstantImpl <em>Constant</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ConstantImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getConstant()
	 * @generated
	 */
	int CONSTANT = 14;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT__COMMENT = PROPERTY__COMMENT;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT__NAME = PROPERTY__NAME;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT__OWNER = PROPERTY__OWNER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT__TYPE = PROPERTY__TYPE;

	/**
	 * The feature id for the '<em><b>Default</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT__DEFAULT = PROPERTY__DEFAULT;

	/**
	 * The number of structural features of the '<em>Constant</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_FEATURE_COUNT = PROPERTY_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.GenericImpl <em>Generic</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.GenericImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getGeneric()
	 * @generated
	 */
	int GENERIC = 15;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC__COMMENT = PROPERTY__COMMENT;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC__NAME = PROPERTY__NAME;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC__OWNER = PROPERTY__OWNER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC__TYPE = PROPERTY__TYPE;

	/**
	 * The feature id for the '<em><b>Default</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC__DEFAULT = PROPERTY__DEFAULT;

	/**
	 * The number of structural features of the '<em>Generic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_FEATURE_COUNT = PROPERTY_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.LibraryForVhdlAmsImpl <em>Library For Vhdl Ams</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.LibraryForVhdlAmsImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getLibraryForVhdlAms()
	 * @generated
	 */
	int LIBRARY_FOR_VHDL_AMS = 16;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIBRARY_FOR_VHDL_AMS__COMMENT = PACKAGE__COMMENT;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIBRARY_FOR_VHDL_AMS__NAME = PACKAGE__NAME;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIBRARY_FOR_VHDL_AMS__OWNER = PACKAGE__OWNER;

	/**
	 * The feature id for the '<em><b>Design Unit</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIBRARY_FOR_VHDL_AMS__DESIGN_UNIT = PACKAGE__DESIGN_UNIT;

	/**
	 * The feature id for the '<em><b>Owner Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIBRARY_FOR_VHDL_AMS__OWNER_MODEL = PACKAGE__OWNER_MODEL;

	/**
	 * The number of structural features of the '<em>Library For Vhdl Ams</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIBRARY_FOR_VHDL_AMS_FEATURE_COUNT = PACKAGE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.StatementImpl <em>Statement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.StatementImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getStatement()
	 * @generated
	 */
	int STATEMENT = 17;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__OWNER = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__BODY = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Statement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ComponentInstanciationImpl <em>Component Instanciation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ComponentInstanciationImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getComponentInstanciation()
	 * @generated
	 */
	int COMPONENT_INSTANCIATION = 18;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCIATION__COMMENT = STATEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCIATION__OWNER = STATEMENT__OWNER;

	/**
	 * The feature id for the '<em><b>Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCIATION__BODY = STATEMENT__BODY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCIATION__NAME = STATEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCIATION__TYPE = STATEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Map</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCIATION__MAP = STATEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Architecture</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCIATION__ARCHITECTURE = STATEMENT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Component Instanciation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCIATION_FEATURE_COUNT = STATEMENT_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.MapImpl <em>Map</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.MapImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getMap()
	 * @generated
	 */
	int MAP = 29;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAP__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAP__OWNER = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Map</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAP_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.PortMapImpl <em>Port Map</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.PortMapImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getPortMap()
	 * @generated
	 */
	int PORT_MAP = 19;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT_MAP__COMMENT = MAP__COMMENT;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT_MAP__OWNER = MAP__OWNER;

	/**
	 * The feature id for the '<em><b>From</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT_MAP__FROM = MAP_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>To</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT_MAP__TO = MAP_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Port Map</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT_MAP_FEATURE_COUNT = MAP_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.LibraryImpl <em>Library</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.LibraryImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getLibrary()
	 * @generated
	 */
	int LIBRARY = 20;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIBRARY__NAME = 0;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIBRARY__OWNER = 1;

	/**
	 * The feature id for the '<em><b>Use</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIBRARY__USE = 2;

	/**
	 * The number of structural features of the '<em>Library</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIBRARY_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.UseImpl <em>Use</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.UseImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getUse()
	 * @generated
	 */
	int USE = 21;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USE__OWNER = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USE__NAME = 1;

	/**
	 * The number of structural features of the '<em>Use</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USE_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.NatureImpl <em>Nature</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.NatureImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getNature()
	 * @generated
	 */
	int NATURE = 22;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NATURE__COMMENT = TYPE__COMMENT;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NATURE__NAME = TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NATURE__OWNER = TYPE__OWNER;

	/**
	 * The number of structural features of the '<em>Nature</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NATURE_FEATURE_COUNT = TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.QuantityImpl <em>Quantity</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.QuantityImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getQuantity()
	 * @generated
	 */
	int QUANTITY = 23;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY__COMMENT = PROPERTY__COMMENT;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY__NAME = PROPERTY__NAME;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY__OWNER = PROPERTY__OWNER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY__TYPE = PROPERTY__TYPE;

	/**
	 * The feature id for the '<em><b>Default</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY__DEFAULT = PROPERTY__DEFAULT;

	/**
	 * The number of structural features of the '<em>Quantity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_FEATURE_COUNT = PROPERTY_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.BranchQuantityImpl <em>Branch Quantity</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.BranchQuantityImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getBranchQuantity()
	 * @generated
	 */
	int BRANCH_QUANTITY = 24;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_QUANTITY__COMMENT = QUANTITY__COMMENT;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_QUANTITY__NAME = QUANTITY__NAME;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_QUANTITY__OWNER = QUANTITY__OWNER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_QUANTITY__TYPE = QUANTITY__TYPE;

	/**
	 * The feature id for the '<em><b>Default</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_QUANTITY__DEFAULT = QUANTITY__DEFAULT;

	/**
	 * The feature id for the '<em><b>Plus terminal</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_QUANTITY__PLUS_TERMINAL = QUANTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Minus terminal</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_QUANTITY__MINUS_TERMINAL = QUANTITY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Through</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_QUANTITY__THROUGH = QUANTITY_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Across</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_QUANTITY__ACROSS = QUANTITY_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Branch Quantity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_QUANTITY_FEATURE_COUNT = QUANTITY_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VariableImpl <em>Variable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VariableImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getVariable()
	 * @generated
	 */
	int VARIABLE = 25;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE__NAME = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE__OWNER = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Variable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.FunctionImpl <em>Function</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.FunctionImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getFunction()
	 * @generated
	 */
	int FUNCTION = 26;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__COMMENT = STATEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__OWNER = STATEMENT__OWNER;

	/**
	 * The feature id for the '<em><b>Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__BODY = STATEMENT__BODY;

	/**
	 * The feature id for the '<em><b>Return Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__RETURN_TYPE = STATEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Parameter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__PARAMETER = STATEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__NAME = STATEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Sequential Statement</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__SEQUENTIAL_STATEMENT = STATEMENT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Function</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_FEATURE_COUNT = STATEMENT_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ParameterImpl <em>Parameter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ParameterImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getParameter()
	 * @generated
	 */
	int PARAMETER = 27;

	/**
	 * The feature id for the '<em><b>Owner Function</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER__OWNER_FUNCTION = 0;

	/**
	 * The feature id for the '<em><b>Owner Process</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER__OWNER_PROCESS = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER__NAME = 2;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER__TYPE = 3;

	/**
	 * The feature id for the '<em><b>Default</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER__DEFAULT = 4;

	/**
	 * The number of structural features of the '<em>Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_FEATURE_COUNT = 5;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.SequentialStatementImpl <em>Sequential Statement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.SequentialStatementImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getSequentialStatement()
	 * @generated
	 */
	int SEQUENTIAL_STATEMENT = 28;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENTIAL_STATEMENT__COMMENT = STATEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENTIAL_STATEMENT__OWNER = STATEMENT__OWNER;

	/**
	 * The feature id for the '<em><b>Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENTIAL_STATEMENT__BODY = STATEMENT__BODY;

	/**
	 * The feature id for the '<em><b>Owner Function</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENTIAL_STATEMENT__OWNER_FUNCTION = STATEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Owner Process</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENTIAL_STATEMENT__OWNER_PROCESS = STATEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Sequential Statement</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENTIAL_STATEMENT__SEQUENTIAL_STATEMENT = STATEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Owner Sequential Statement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENTIAL_STATEMENT__OWNER_SEQUENTIAL_STATEMENT = STATEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Predecessor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENTIAL_STATEMENT__PREDECESSOR = STATEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Successor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENTIAL_STATEMENT__SUCCESSOR = STATEMENT_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Sequential Statement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENTIAL_STATEMENT_FEATURE_COUNT = STATEMENT_FEATURE_COUNT + 6;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.GenericMapImpl <em>Generic Map</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.GenericMapImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getGenericMap()
	 * @generated
	 */
	int GENERIC_MAP = 30;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_MAP__COMMENT = MAP__COMMENT;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_MAP__OWNER = MAP__OWNER;

	/**
	 * The feature id for the '<em><b>From</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_MAP__FROM = MAP_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>To</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_MAP__TO = MAP_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Generic Map</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_MAP_FEATURE_COUNT = MAP_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ExpressionImpl <em>Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ExpressionImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getExpression()
	 * @generated
	 */
	int EXPRESSION = 31;

	/**
	 * The feature id for the '<em><b>Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION__BODY = 0;

	/**
	 * The number of structural features of the '<em>Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ConcurrentialStatementImpl <em>Concurrential Statement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ConcurrentialStatementImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getConcurrentialStatement()
	 * @generated
	 */
	int CONCURRENTIAL_STATEMENT = 32;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCURRENTIAL_STATEMENT__COMMENT = STATEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCURRENTIAL_STATEMENT__OWNER = STATEMENT__OWNER;

	/**
	 * The feature id for the '<em><b>Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCURRENTIAL_STATEMENT__BODY = STATEMENT__BODY;

	/**
	 * The number of structural features of the '<em>Concurrential Statement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCURRENTIAL_STATEMENT_FEATURE_COUNT = STATEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.EquationImpl <em>Equation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.EquationImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getEquation()
	 * @generated
	 */
	int EQUATION = 33;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUATION__COMMENT = CONCURRENTIAL_STATEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUATION__OWNER = CONCURRENTIAL_STATEMENT__OWNER;

	/**
	 * The feature id for the '<em><b>Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUATION__BODY = CONCURRENTIAL_STATEMENT__BODY;

	/**
	 * The number of structural features of the '<em>Equation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUATION_FEATURE_COUNT = CONCURRENTIAL_STATEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ProcessImpl <em>Process</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ProcessImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getProcess()
	 * @generated
	 */
	int PROCESS = 34;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__COMMENT = CONCURRENTIAL_STATEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__OWNER = CONCURRENTIAL_STATEMENT__OWNER;

	/**
	 * The feature id for the '<em><b>Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__BODY = CONCURRENTIAL_STATEMENT__BODY;

	/**
	 * The feature id for the '<em><b>Parameter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__PARAMETER = CONCURRENTIAL_STATEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Sequential Statement</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__SEQUENTIAL_STATEMENT = CONCURRENTIAL_STATEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__NAME = CONCURRENTIAL_STATEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__VARIABLES = CONCURRENTIAL_STATEMENT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Process</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_FEATURE_COUNT = CONCURRENTIAL_STATEMENT_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.IfThenStatementImpl <em>If Then Statement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.IfThenStatementImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getIfThenStatement()
	 * @generated
	 */
	int IF_THEN_STATEMENT = 35;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IF_THEN_STATEMENT__COMMENT = SEQUENTIAL_STATEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IF_THEN_STATEMENT__OWNER = SEQUENTIAL_STATEMENT__OWNER;

	/**
	 * The feature id for the '<em><b>Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IF_THEN_STATEMENT__BODY = SEQUENTIAL_STATEMENT__BODY;

	/**
	 * The feature id for the '<em><b>Owner Function</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IF_THEN_STATEMENT__OWNER_FUNCTION = SEQUENTIAL_STATEMENT__OWNER_FUNCTION;

	/**
	 * The feature id for the '<em><b>Owner Process</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IF_THEN_STATEMENT__OWNER_PROCESS = SEQUENTIAL_STATEMENT__OWNER_PROCESS;

	/**
	 * The feature id for the '<em><b>Sequential Statement</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IF_THEN_STATEMENT__SEQUENTIAL_STATEMENT = SEQUENTIAL_STATEMENT__SEQUENTIAL_STATEMENT;

	/**
	 * The feature id for the '<em><b>Owner Sequential Statement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IF_THEN_STATEMENT__OWNER_SEQUENTIAL_STATEMENT = SEQUENTIAL_STATEMENT__OWNER_SEQUENTIAL_STATEMENT;

	/**
	 * The feature id for the '<em><b>Predecessor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IF_THEN_STATEMENT__PREDECESSOR = SEQUENTIAL_STATEMENT__PREDECESSOR;

	/**
	 * The feature id for the '<em><b>Successor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IF_THEN_STATEMENT__SUCCESSOR = SEQUENTIAL_STATEMENT__SUCCESSOR;

	/**
	 * The feature id for the '<em><b>Boolean Expression</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IF_THEN_STATEMENT__BOOLEAN_EXPRESSION = SEQUENTIAL_STATEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Else</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IF_THEN_STATEMENT__ELSE = SEQUENTIAL_STATEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>If Then Statement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IF_THEN_STATEMENT_FEATURE_COUNT = SEQUENTIAL_STATEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ElseStatementImpl <em>Else Statement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ElseStatementImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getElseStatement()
	 * @generated
	 */
	int ELSE_STATEMENT = 36;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELSE_STATEMENT__COMMENT = SEQUENTIAL_STATEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELSE_STATEMENT__OWNER = SEQUENTIAL_STATEMENT__OWNER;

	/**
	 * The feature id for the '<em><b>Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELSE_STATEMENT__BODY = SEQUENTIAL_STATEMENT__BODY;

	/**
	 * The feature id for the '<em><b>Owner Function</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELSE_STATEMENT__OWNER_FUNCTION = SEQUENTIAL_STATEMENT__OWNER_FUNCTION;

	/**
	 * The feature id for the '<em><b>Owner Process</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELSE_STATEMENT__OWNER_PROCESS = SEQUENTIAL_STATEMENT__OWNER_PROCESS;

	/**
	 * The feature id for the '<em><b>Sequential Statement</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELSE_STATEMENT__SEQUENTIAL_STATEMENT = SEQUENTIAL_STATEMENT__SEQUENTIAL_STATEMENT;

	/**
	 * The feature id for the '<em><b>Owner Sequential Statement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELSE_STATEMENT__OWNER_SEQUENTIAL_STATEMENT = SEQUENTIAL_STATEMENT__OWNER_SEQUENTIAL_STATEMENT;

	/**
	 * The feature id for the '<em><b>Predecessor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELSE_STATEMENT__PREDECESSOR = SEQUENTIAL_STATEMENT__PREDECESSOR;

	/**
	 * The feature id for the '<em><b>Successor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELSE_STATEMENT__SUCCESSOR = SEQUENTIAL_STATEMENT__SUCCESSOR;

	/**
	 * The feature id for the '<em><b>If</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELSE_STATEMENT__IF = SEQUENTIAL_STATEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Else Statement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELSE_STATEMENT_FEATURE_COUNT = SEQUENTIAL_STATEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ForStatementImpl <em>For Statement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ForStatementImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getForStatement()
	 * @generated
	 */
	int FOR_STATEMENT = 37;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_STATEMENT__COMMENT = SEQUENTIAL_STATEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_STATEMENT__OWNER = SEQUENTIAL_STATEMENT__OWNER;

	/**
	 * The feature id for the '<em><b>Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_STATEMENT__BODY = SEQUENTIAL_STATEMENT__BODY;

	/**
	 * The feature id for the '<em><b>Owner Function</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_STATEMENT__OWNER_FUNCTION = SEQUENTIAL_STATEMENT__OWNER_FUNCTION;

	/**
	 * The feature id for the '<em><b>Owner Process</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_STATEMENT__OWNER_PROCESS = SEQUENTIAL_STATEMENT__OWNER_PROCESS;

	/**
	 * The feature id for the '<em><b>Sequential Statement</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_STATEMENT__SEQUENTIAL_STATEMENT = SEQUENTIAL_STATEMENT__SEQUENTIAL_STATEMENT;

	/**
	 * The feature id for the '<em><b>Owner Sequential Statement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_STATEMENT__OWNER_SEQUENTIAL_STATEMENT = SEQUENTIAL_STATEMENT__OWNER_SEQUENTIAL_STATEMENT;

	/**
	 * The feature id for the '<em><b>Predecessor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_STATEMENT__PREDECESSOR = SEQUENTIAL_STATEMENT__PREDECESSOR;

	/**
	 * The feature id for the '<em><b>Successor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_STATEMENT__SUCCESSOR = SEQUENTIAL_STATEMENT__SUCCESSOR;

	/**
	 * The feature id for the '<em><b>Loop Condition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_STATEMENT__LOOP_CONDITION = SEQUENTIAL_STATEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>For Statement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_STATEMENT_FEATURE_COUNT = SEQUENTIAL_STATEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.StatementsImpl <em>Statements</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.StatementsImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getStatements()
	 * @generated
	 */
	int STATEMENTS = 38;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENTS__COMMENT = SEQUENTIAL_STATEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENTS__OWNER = SEQUENTIAL_STATEMENT__OWNER;

	/**
	 * The feature id for the '<em><b>Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENTS__BODY = SEQUENTIAL_STATEMENT__BODY;

	/**
	 * The feature id for the '<em><b>Owner Function</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENTS__OWNER_FUNCTION = SEQUENTIAL_STATEMENT__OWNER_FUNCTION;

	/**
	 * The feature id for the '<em><b>Owner Process</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENTS__OWNER_PROCESS = SEQUENTIAL_STATEMENT__OWNER_PROCESS;

	/**
	 * The feature id for the '<em><b>Sequential Statement</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENTS__SEQUENTIAL_STATEMENT = SEQUENTIAL_STATEMENT__SEQUENTIAL_STATEMENT;

	/**
	 * The feature id for the '<em><b>Owner Sequential Statement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENTS__OWNER_SEQUENTIAL_STATEMENT = SEQUENTIAL_STATEMENT__OWNER_SEQUENTIAL_STATEMENT;

	/**
	 * The feature id for the '<em><b>Predecessor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENTS__PREDECESSOR = SEQUENTIAL_STATEMENT__PREDECESSOR;

	/**
	 * The feature id for the '<em><b>Successor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENTS__SUCCESSOR = SEQUENTIAL_STATEMENT__SUCCESSOR;

	/**
	 * The number of structural features of the '<em>Statements</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENTS_FEATURE_COUNT = SEQUENTIAL_STATEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ProcessVariableImpl <em>Process Variable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ProcessVariableImpl
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getProcessVariable()
	 * @generated
	 */
	int PROCESS_VARIABLE = 39;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_VARIABLE__NAME = 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_VARIABLE__TYPE = 1;

	/**
	 * The feature id for the '<em><b>Default</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_VARIABLE__DEFAULT = 2;

	/**
	 * The feature id for the '<em><b>Owner Process</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_VARIABLE__OWNER_PROCESS = 3;

	/**
	 * The number of structural features of the '<em>Process Variable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_VARIABLE_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.PortDirection <em>Port Direction</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.PortDirection
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getPortDirection()
	 * @generated
	 */
	int PORT_DIRECTION = 40;


	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Entity <em>Entity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Entity</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Entity
	 * @generated
	 */
	EClass getEntity();

	/**
	 * Returns the meta object for the reference list '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Entity#getArchitecture <em>Architecture</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Architecture</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Entity#getArchitecture()
	 * @see #getEntity()
	 * @generated
	 */
	EReference getEntity_Architecture();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.DesignUnit <em>Design Unit</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Design Unit</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.DesignUnit
	 * @generated
	 */
	EClass getDesignUnit();

	/**
	 * Returns the meta object for the attribute '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.DesignUnit#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.DesignUnit#getName()
	 * @see #getDesignUnit()
	 * @generated
	 */
	EAttribute getDesignUnit_Name();

	/**
	 * Returns the meta object for the container reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.DesignUnit#getOwner <em>Owner</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Owner</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.DesignUnit#getOwner()
	 * @see #getDesignUnit()
	 * @generated
	 */
	EReference getDesignUnit_Owner();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Architecture <em>Architecture</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Architecture</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Architecture
	 * @generated
	 */
	EClass getArchitecture();

	/**
	 * Returns the meta object for the reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Architecture#getEntity <em>Entity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Entity</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Architecture#getEntity()
	 * @see #getArchitecture()
	 * @generated
	 */
	EReference getArchitecture_Entity();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Element <em>Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Element</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Element
	 * @generated
	 */
	EClass getElement();

	/**
	 * Returns the meta object for the reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Element#getComment <em>Comment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Comment</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Element#getComment()
	 * @see #getElement()
	 * @generated
	 */
	EReference getElement_Comment();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Component <em>Component</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Component</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Component
	 * @generated
	 */
	EClass getComponent();

	/**
	 * Returns the meta object for the containment reference list '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Component#getProperty <em>Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Property</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Component#getProperty()
	 * @see #getComponent()
	 * @generated
	 */
	EReference getComponent_Property();

	/**
	 * Returns the meta object for the containment reference list '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Component#getStatement <em>Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Statement</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Component#getStatement()
	 * @see #getComponent()
	 * @generated
	 */
	EReference getComponent_Statement();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Package <em>Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Package</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Package
	 * @generated
	 */
	EClass getPackage();

	/**
	 * Returns the meta object for the containment reference list '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Package#getDesignUnit <em>Design Unit</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Design Unit</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Package#getDesignUnit()
	 * @see #getPackage()
	 * @generated
	 */
	EReference getPackage_DesignUnit();

	/**
	 * Returns the meta object for the container reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Package#getOwnerModel <em>Owner Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Owner Model</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Package#getOwnerModel()
	 * @see #getPackage()
	 * @generated
	 */
	EReference getPackage_OwnerModel();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.VAModel <em>VA Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>VA Model</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.VAModel
	 * @generated
	 */
	EClass getVAModel();

	/**
	 * Returns the meta object for the containment reference list '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.VAModel#getPackage <em>Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Package</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.VAModel#getPackage()
	 * @see #getVAModel()
	 * @generated
	 */
	EReference getVAModel_Package();

	/**
	 * Returns the meta object for the attribute '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.VAModel#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.VAModel#getName()
	 * @see #getVAModel()
	 * @generated
	 */
	EAttribute getVAModel_Name();

	/**
	 * Returns the meta object for the containment reference list '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.VAModel#getLibrary <em>Library</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Library</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.VAModel#getLibrary()
	 * @see #getVAModel()
	 * @generated
	 */
	EReference getVAModel_Library();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Comment <em>Comment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Comment</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Comment
	 * @generated
	 */
	EClass getComment();

	/**
	 * Returns the meta object for the reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Comment#getElement <em>Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Element</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Comment#getElement()
	 * @see #getComment()
	 * @generated
	 */
	EReference getComment_Element();

	/**
	 * Returns the meta object for the attribute '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Comment#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Comment#getDescription()
	 * @see #getComment()
	 * @generated
	 */
	EAttribute getComment_Description();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Property <em>Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Property</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Property
	 * @generated
	 */
	EClass getProperty();

	/**
	 * Returns the meta object for the attribute '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Property#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Property#getName()
	 * @see #getProperty()
	 * @generated
	 */
	EAttribute getProperty_Name();

	/**
	 * Returns the meta object for the container reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Property#getOwner <em>Owner</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Owner</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Property#getOwner()
	 * @see #getProperty()
	 * @generated
	 */
	EReference getProperty_Owner();

	/**
	 * Returns the meta object for the reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Property#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Type</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Property#getType()
	 * @see #getProperty()
	 * @generated
	 */
	EReference getProperty_Type();

	/**
	 * Returns the meta object for the attribute '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Property#getDefault <em>Default</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Default</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Property#getDefault()
	 * @see #getProperty()
	 * @generated
	 */
	EAttribute getProperty_Default();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Port <em>Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Port</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Port
	 * @generated
	 */
	EClass getPort();

	/**
	 * Returns the meta object for the attribute '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Port#getDirection <em>Direction</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Direction</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Port#getDirection()
	 * @see #getPort()
	 * @generated
	 */
	EAttribute getPort_Direction();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Terminal <em>Terminal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Terminal</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Terminal
	 * @generated
	 */
	EClass getTerminal();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Signal <em>Signal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Signal</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Signal
	 * @generated
	 */
	EClass getSignal();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.QuantityPort <em>Quantity Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Quantity Port</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.QuantityPort
	 * @generated
	 */
	EClass getQuantityPort();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Type <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Type</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Type
	 * @generated
	 */
	EClass getType();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Constant <em>Constant</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Constant</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Constant
	 * @generated
	 */
	EClass getConstant();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Generic <em>Generic</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Generic</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Generic
	 * @generated
	 */
	EClass getGeneric();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.LibraryForVhdlAms <em>Library For Vhdl Ams</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Library For Vhdl Ams</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.LibraryForVhdlAms
	 * @generated
	 */
	EClass getLibraryForVhdlAms();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Statement <em>Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Statement</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Statement
	 * @generated
	 */
	EClass getStatement();

	/**
	 * Returns the meta object for the container reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Statement#getOwner <em>Owner</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Owner</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Statement#getOwner()
	 * @see #getStatement()
	 * @generated
	 */
	EReference getStatement_Owner();

	/**
	 * Returns the meta object for the attribute '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Statement#getBody <em>Body</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Body</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Statement#getBody()
	 * @see #getStatement()
	 * @generated
	 */
	EAttribute getStatement_Body();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ComponentInstanciation <em>Component Instanciation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Component Instanciation</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ComponentInstanciation
	 * @generated
	 */
	EClass getComponentInstanciation();

	/**
	 * Returns the meta object for the attribute '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ComponentInstanciation#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ComponentInstanciation#getName()
	 * @see #getComponentInstanciation()
	 * @generated
	 */
	EAttribute getComponentInstanciation_Name();

	/**
	 * Returns the meta object for the reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ComponentInstanciation#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Type</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ComponentInstanciation#getType()
	 * @see #getComponentInstanciation()
	 * @generated
	 */
	EReference getComponentInstanciation_Type();

	/**
	 * Returns the meta object for the containment reference list '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ComponentInstanciation#getMap <em>Map</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Map</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ComponentInstanciation#getMap()
	 * @see #getComponentInstanciation()
	 * @generated
	 */
	EReference getComponentInstanciation_Map();

	/**
	 * Returns the meta object for the reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ComponentInstanciation#getArchitecture <em>Architecture</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Architecture</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ComponentInstanciation#getArchitecture()
	 * @see #getComponentInstanciation()
	 * @generated
	 */
	EReference getComponentInstanciation_Architecture();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.PortMap <em>Port Map</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Port Map</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.PortMap
	 * @generated
	 */
	EClass getPortMap();

	/**
	 * Returns the meta object for the reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.PortMap#getFrom <em>From</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>From</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.PortMap#getFrom()
	 * @see #getPortMap()
	 * @generated
	 */
	EReference getPortMap_From();

	/**
	 * Returns the meta object for the reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.PortMap#getTo <em>To</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>To</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.PortMap#getTo()
	 * @see #getPortMap()
	 * @generated
	 */
	EReference getPortMap_To();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Library <em>Library</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Library</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Library
	 * @generated
	 */
	EClass getLibrary();

	/**
	 * Returns the meta object for the attribute '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Library#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Library#getName()
	 * @see #getLibrary()
	 * @generated
	 */
	EAttribute getLibrary_Name();

	/**
	 * Returns the meta object for the container reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Library#getOwner <em>Owner</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Owner</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Library#getOwner()
	 * @see #getLibrary()
	 * @generated
	 */
	EReference getLibrary_Owner();

	/**
	 * Returns the meta object for the containment reference list '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Library#getUse <em>Use</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Use</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Library#getUse()
	 * @see #getLibrary()
	 * @generated
	 */
	EReference getLibrary_Use();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Use <em>Use</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Use</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Use
	 * @generated
	 */
	EClass getUse();

	/**
	 * Returns the meta object for the container reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Use#getOwner <em>Owner</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Owner</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Use#getOwner()
	 * @see #getUse()
	 * @generated
	 */
	EReference getUse_Owner();

	/**
	 * Returns the meta object for the attribute '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Use#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Use#getName()
	 * @see #getUse()
	 * @generated
	 */
	EAttribute getUse_Name();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Nature <em>Nature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Nature</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Nature
	 * @generated
	 */
	EClass getNature();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Quantity <em>Quantity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Quantity</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Quantity
	 * @generated
	 */
	EClass getQuantity();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.BranchQuantity <em>Branch Quantity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Branch Quantity</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.BranchQuantity
	 * @generated
	 */
	EClass getBranchQuantity();

	/**
	 * Returns the meta object for the reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.BranchQuantity#getPlus_terminal <em>Plus terminal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Plus terminal</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.BranchQuantity#getPlus_terminal()
	 * @see #getBranchQuantity()
	 * @generated
	 */
	EReference getBranchQuantity_Plus_terminal();

	/**
	 * Returns the meta object for the reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.BranchQuantity#getMinus_terminal <em>Minus terminal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Minus terminal</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.BranchQuantity#getMinus_terminal()
	 * @see #getBranchQuantity()
	 * @generated
	 */
	EReference getBranchQuantity_Minus_terminal();

	/**
	 * Returns the meta object for the reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.BranchQuantity#getThrough <em>Through</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Through</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.BranchQuantity#getThrough()
	 * @see #getBranchQuantity()
	 * @generated
	 */
	EReference getBranchQuantity_Through();

	/**
	 * Returns the meta object for the reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.BranchQuantity#getAcross <em>Across</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Across</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.BranchQuantity#getAcross()
	 * @see #getBranchQuantity()
	 * @generated
	 */
	EReference getBranchQuantity_Across();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Variable <em>Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Variable</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Variable
	 * @generated
	 */
	EClass getVariable();

	/**
	 * Returns the meta object for the attribute '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Variable#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Variable#getName()
	 * @see #getVariable()
	 * @generated
	 */
	EAttribute getVariable_Name();

	/**
	 * Returns the meta object for the reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Variable#getOwner <em>Owner</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Owner</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Variable#getOwner()
	 * @see #getVariable()
	 * @generated
	 */
	EReference getVariable_Owner();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Function <em>Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Function</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Function
	 * @generated
	 */
	EClass getFunction();

	/**
	 * Returns the meta object for the reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Function#getReturnType <em>Return Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Return Type</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Function#getReturnType()
	 * @see #getFunction()
	 * @generated
	 */
	EReference getFunction_ReturnType();

	/**
	 * Returns the meta object for the containment reference list '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Function#getParameter <em>Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Parameter</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Function#getParameter()
	 * @see #getFunction()
	 * @generated
	 */
	EReference getFunction_Parameter();

	/**
	 * Returns the meta object for the attribute '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Function#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Function#getName()
	 * @see #getFunction()
	 * @generated
	 */
	EAttribute getFunction_Name();

	/**
	 * Returns the meta object for the containment reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Function#getSequentialStatement <em>Sequential Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Sequential Statement</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Function#getSequentialStatement()
	 * @see #getFunction()
	 * @generated
	 */
	EReference getFunction_SequentialStatement();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Parameter <em>Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Parameter</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Parameter
	 * @generated
	 */
	EClass getParameter();

	/**
	 * Returns the meta object for the container reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Parameter#getOwnerFunction <em>Owner Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Owner Function</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Parameter#getOwnerFunction()
	 * @see #getParameter()
	 * @generated
	 */
	EReference getParameter_OwnerFunction();

	/**
	 * Returns the meta object for the attribute '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Parameter#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Parameter#getName()
	 * @see #getParameter()
	 * @generated
	 */
	EAttribute getParameter_Name();

	/**
	 * Returns the meta object for the reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Parameter#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Type</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Parameter#getType()
	 * @see #getParameter()
	 * @generated
	 */
	EReference getParameter_Type();

	/**
	 * Returns the meta object for the attribute '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Parameter#getDefault <em>Default</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Default</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Parameter#getDefault()
	 * @see #getParameter()
	 * @generated
	 */
	EAttribute getParameter_Default();

	/**
	 * Returns the meta object for the container reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Parameter#getOwnerProcess <em>Owner Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Owner Process</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Parameter#getOwnerProcess()
	 * @see #getParameter()
	 * @generated
	 */
	EReference getParameter_OwnerProcess();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement <em>Sequential Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Sequential Statement</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement
	 * @generated
	 */
	EClass getSequentialStatement();

	/**
	 * Returns the meta object for the container reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getOwnerFunction <em>Owner Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Owner Function</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getOwnerFunction()
	 * @see #getSequentialStatement()
	 * @generated
	 */
	EReference getSequentialStatement_OwnerFunction();

	/**
	 * Returns the meta object for the container reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getOwnerProcess <em>Owner Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Owner Process</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getOwnerProcess()
	 * @see #getSequentialStatement()
	 * @generated
	 */
	EReference getSequentialStatement_OwnerProcess();

	/**
	 * Returns the meta object for the containment reference list '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getSequentialStatement <em>Sequential Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Sequential Statement</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getSequentialStatement()
	 * @see #getSequentialStatement()
	 * @generated
	 */
	EReference getSequentialStatement_SequentialStatement();

	/**
	 * Returns the meta object for the container reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getOwnerSequentialStatement <em>Owner Sequential Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Owner Sequential Statement</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getOwnerSequentialStatement()
	 * @see #getSequentialStatement()
	 * @generated
	 */
	EReference getSequentialStatement_OwnerSequentialStatement();

	/**
	 * Returns the meta object for the reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getPredecessor <em>Predecessor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Predecessor</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getPredecessor()
	 * @see #getSequentialStatement()
	 * @generated
	 */
	EReference getSequentialStatement_Predecessor();

	/**
	 * Returns the meta object for the reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getSuccessor <em>Successor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Successor</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getSuccessor()
	 * @see #getSequentialStatement()
	 * @generated
	 */
	EReference getSequentialStatement_Successor();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Map <em>Map</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Map</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Map
	 * @generated
	 */
	EClass getMap();

	/**
	 * Returns the meta object for the container reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Map#getOwner <em>Owner</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Owner</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Map#getOwner()
	 * @see #getMap()
	 * @generated
	 */
	EReference getMap_Owner();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.GenericMap <em>Generic Map</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Generic Map</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.GenericMap
	 * @generated
	 */
	EClass getGenericMap();

	/**
	 * Returns the meta object for the reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.GenericMap#getFrom <em>From</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>From</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.GenericMap#getFrom()
	 * @see #getGenericMap()
	 * @generated
	 */
	EReference getGenericMap_From();

	/**
	 * Returns the meta object for the reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.GenericMap#getTo <em>To</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>To</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.GenericMap#getTo()
	 * @see #getGenericMap()
	 * @generated
	 */
	EReference getGenericMap_To();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Expression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Expression</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Expression
	 * @generated
	 */
	EClass getExpression();

	/**
	 * Returns the meta object for the attribute '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Expression#getBody <em>Body</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Body</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Expression#getBody()
	 * @see #getExpression()
	 * @generated
	 */
	EAttribute getExpression_Body();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ConcurrentialStatement <em>Concurrential Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Concurrential Statement</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ConcurrentialStatement
	 * @generated
	 */
	EClass getConcurrentialStatement();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Equation <em>Equation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Equation</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Equation
	 * @generated
	 */
	EClass getEquation();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Process <em>Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Process</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Process
	 * @generated
	 */
	EClass getProcess();

	/**
	 * Returns the meta object for the containment reference list '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Process#getParameter <em>Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Parameter</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Process#getParameter()
	 * @see #getProcess()
	 * @generated
	 */
	EReference getProcess_Parameter();

	/**
	 * Returns the meta object for the containment reference list '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Process#getSequentialStatement <em>Sequential Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Sequential Statement</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Process#getSequentialStatement()
	 * @see #getProcess()
	 * @generated
	 */
	EReference getProcess_SequentialStatement();

	/**
	 * Returns the meta object for the attribute '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Process#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Process#getName()
	 * @see #getProcess()
	 * @generated
	 */
	EAttribute getProcess_Name();

	/**
	 * Returns the meta object for the containment reference list '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Process#getVariables <em>Variables</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Variables</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Process#getVariables()
	 * @see #getProcess()
	 * @generated
	 */
	EReference getProcess_Variables();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.IfThenStatement <em>If Then Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>If Then Statement</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.IfThenStatement
	 * @generated
	 */
	EClass getIfThenStatement();

	/**
	 * Returns the meta object for the attribute '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.IfThenStatement#getBooleanExpression <em>Boolean Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Boolean Expression</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.IfThenStatement#getBooleanExpression()
	 * @see #getIfThenStatement()
	 * @generated
	 */
	EAttribute getIfThenStatement_BooleanExpression();

	/**
	 * Returns the meta object for the reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.IfThenStatement#getElse <em>Else</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Else</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.IfThenStatement#getElse()
	 * @see #getIfThenStatement()
	 * @generated
	 */
	EReference getIfThenStatement_Else();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ElseStatement <em>Else Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Else Statement</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ElseStatement
	 * @generated
	 */
	EClass getElseStatement();

	/**
	 * Returns the meta object for the reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ElseStatement#getIf <em>If</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>If</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ElseStatement#getIf()
	 * @see #getElseStatement()
	 * @generated
	 */
	EReference getElseStatement_If();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ForStatement <em>For Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>For Statement</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ForStatement
	 * @generated
	 */
	EClass getForStatement();

	/**
	 * Returns the meta object for the attribute '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ForStatement#getLoopCondition <em>Loop Condition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Loop Condition</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ForStatement#getLoopCondition()
	 * @see #getForStatement()
	 * @generated
	 */
	EAttribute getForStatement_LoopCondition();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Statements <em>Statements</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Statements</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Statements
	 * @generated
	 */
	EClass getStatements();

	/**
	 * Returns the meta object for class '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ProcessVariable <em>Process Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Process Variable</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ProcessVariable
	 * @generated
	 */
	EClass getProcessVariable();

	/**
	 * Returns the meta object for the attribute '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ProcessVariable#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ProcessVariable#getName()
	 * @see #getProcessVariable()
	 * @generated
	 */
	EAttribute getProcessVariable_Name();

	/**
	 * Returns the meta object for the reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ProcessVariable#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Type</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ProcessVariable#getType()
	 * @see #getProcessVariable()
	 * @generated
	 */
	EReference getProcessVariable_Type();

	/**
	 * Returns the meta object for the attribute '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ProcessVariable#getDefault <em>Default</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Default</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ProcessVariable#getDefault()
	 * @see #getProcessVariable()
	 * @generated
	 */
	EAttribute getProcessVariable_Default();

	/**
	 * Returns the meta object for the container reference '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ProcessVariable#getOwnerProcess <em>Owner Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Owner Process</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ProcessVariable#getOwnerProcess()
	 * @see #getProcessVariable()
	 * @generated
	 */
	EReference getProcessVariable_OwnerProcess();

	/**
	 * Returns the meta object for enum '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.PortDirection <em>Port Direction</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Port Direction</em>'.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.PortDirection
	 * @generated
	 */
	EEnum getPortDirection();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	VhdlamsFactory getVhdlamsFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.EntityImpl <em>Entity</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.EntityImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getEntity()
		 * @generated
		 */
		EClass ENTITY = eINSTANCE.getEntity();

		/**
		 * The meta object literal for the '<em><b>Architecture</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ENTITY__ARCHITECTURE = eINSTANCE.getEntity_Architecture();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.DesignUnitImpl <em>Design Unit</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.DesignUnitImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getDesignUnit()
		 * @generated
		 */
		EClass DESIGN_UNIT = eINSTANCE.getDesignUnit();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DESIGN_UNIT__NAME = eINSTANCE.getDesignUnit_Name();

		/**
		 * The meta object literal for the '<em><b>Owner</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DESIGN_UNIT__OWNER = eINSTANCE.getDesignUnit_Owner();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ArchitectureImpl <em>Architecture</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ArchitectureImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getArchitecture()
		 * @generated
		 */
		EClass ARCHITECTURE = eINSTANCE.getArchitecture();

		/**
		 * The meta object literal for the '<em><b>Entity</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ARCHITECTURE__ENTITY = eINSTANCE.getArchitecture_Entity();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ElementImpl <em>Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ElementImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getElement()
		 * @generated
		 */
		EClass ELEMENT = eINSTANCE.getElement();

		/**
		 * The meta object literal for the '<em><b>Comment</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ELEMENT__COMMENT = eINSTANCE.getElement_Comment();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ComponentImpl <em>Component</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ComponentImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getComponent()
		 * @generated
		 */
		EClass COMPONENT = eINSTANCE.getComponent();

		/**
		 * The meta object literal for the '<em><b>Property</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPONENT__PROPERTY = eINSTANCE.getComponent_Property();

		/**
		 * The meta object literal for the '<em><b>Statement</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPONENT__STATEMENT = eINSTANCE.getComponent_Statement();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.PackageImpl <em>Package</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.PackageImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getPackage()
		 * @generated
		 */
		EClass PACKAGE = eINSTANCE.getPackage();

		/**
		 * The meta object literal for the '<em><b>Design Unit</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PACKAGE__DESIGN_UNIT = eINSTANCE.getPackage_DesignUnit();

		/**
		 * The meta object literal for the '<em><b>Owner Model</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PACKAGE__OWNER_MODEL = eINSTANCE.getPackage_OwnerModel();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VAModelImpl <em>VA Model</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VAModelImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getVAModel()
		 * @generated
		 */
		EClass VA_MODEL = eINSTANCE.getVAModel();

		/**
		 * The meta object literal for the '<em><b>Package</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VA_MODEL__PACKAGE = eINSTANCE.getVAModel_Package();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute VA_MODEL__NAME = eINSTANCE.getVAModel_Name();

		/**
		 * The meta object literal for the '<em><b>Library</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VA_MODEL__LIBRARY = eINSTANCE.getVAModel_Library();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.CommentImpl <em>Comment</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.CommentImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getComment()
		 * @generated
		 */
		EClass COMMENT = eINSTANCE.getComment();

		/**
		 * The meta object literal for the '<em><b>Element</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMMENT__ELEMENT = eINSTANCE.getComment_Element();

		/**
		 * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMMENT__DESCRIPTION = eINSTANCE.getComment_Description();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.PropertyImpl <em>Property</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.PropertyImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getProperty()
		 * @generated
		 */
		EClass PROPERTY = eINSTANCE.getProperty();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROPERTY__NAME = eINSTANCE.getProperty_Name();

		/**
		 * The meta object literal for the '<em><b>Owner</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PROPERTY__OWNER = eINSTANCE.getProperty_Owner();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PROPERTY__TYPE = eINSTANCE.getProperty_Type();

		/**
		 * The meta object literal for the '<em><b>Default</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROPERTY__DEFAULT = eINSTANCE.getProperty_Default();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.PortImpl <em>Port</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.PortImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getPort()
		 * @generated
		 */
		EClass PORT = eINSTANCE.getPort();

		/**
		 * The meta object literal for the '<em><b>Direction</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PORT__DIRECTION = eINSTANCE.getPort_Direction();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.TerminalImpl <em>Terminal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.TerminalImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getTerminal()
		 * @generated
		 */
		EClass TERMINAL = eINSTANCE.getTerminal();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.SignalImpl <em>Signal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.SignalImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getSignal()
		 * @generated
		 */
		EClass SIGNAL = eINSTANCE.getSignal();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.QuantityPortImpl <em>Quantity Port</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.QuantityPortImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getQuantityPort()
		 * @generated
		 */
		EClass QUANTITY_PORT = eINSTANCE.getQuantityPort();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.TypeImpl <em>Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.TypeImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getType()
		 * @generated
		 */
		EClass TYPE = eINSTANCE.getType();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ConstantImpl <em>Constant</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ConstantImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getConstant()
		 * @generated
		 */
		EClass CONSTANT = eINSTANCE.getConstant();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.GenericImpl <em>Generic</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.GenericImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getGeneric()
		 * @generated
		 */
		EClass GENERIC = eINSTANCE.getGeneric();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.LibraryForVhdlAmsImpl <em>Library For Vhdl Ams</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.LibraryForVhdlAmsImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getLibraryForVhdlAms()
		 * @generated
		 */
		EClass LIBRARY_FOR_VHDL_AMS = eINSTANCE.getLibraryForVhdlAms();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.StatementImpl <em>Statement</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.StatementImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getStatement()
		 * @generated
		 */
		EClass STATEMENT = eINSTANCE.getStatement();

		/**
		 * The meta object literal for the '<em><b>Owner</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference STATEMENT__OWNER = eINSTANCE.getStatement_Owner();

		/**
		 * The meta object literal for the '<em><b>Body</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STATEMENT__BODY = eINSTANCE.getStatement_Body();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ComponentInstanciationImpl <em>Component Instanciation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ComponentInstanciationImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getComponentInstanciation()
		 * @generated
		 */
		EClass COMPONENT_INSTANCIATION = eINSTANCE.getComponentInstanciation();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMPONENT_INSTANCIATION__NAME = eINSTANCE.getComponentInstanciation_Name();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPONENT_INSTANCIATION__TYPE = eINSTANCE.getComponentInstanciation_Type();

		/**
		 * The meta object literal for the '<em><b>Map</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPONENT_INSTANCIATION__MAP = eINSTANCE.getComponentInstanciation_Map();

		/**
		 * The meta object literal for the '<em><b>Architecture</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPONENT_INSTANCIATION__ARCHITECTURE = eINSTANCE.getComponentInstanciation_Architecture();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.PortMapImpl <em>Port Map</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.PortMapImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getPortMap()
		 * @generated
		 */
		EClass PORT_MAP = eINSTANCE.getPortMap();

		/**
		 * The meta object literal for the '<em><b>From</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PORT_MAP__FROM = eINSTANCE.getPortMap_From();

		/**
		 * The meta object literal for the '<em><b>To</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PORT_MAP__TO = eINSTANCE.getPortMap_To();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.LibraryImpl <em>Library</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.LibraryImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getLibrary()
		 * @generated
		 */
		EClass LIBRARY = eINSTANCE.getLibrary();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LIBRARY__NAME = eINSTANCE.getLibrary_Name();

		/**
		 * The meta object literal for the '<em><b>Owner</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LIBRARY__OWNER = eINSTANCE.getLibrary_Owner();

		/**
		 * The meta object literal for the '<em><b>Use</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LIBRARY__USE = eINSTANCE.getLibrary_Use();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.UseImpl <em>Use</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.UseImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getUse()
		 * @generated
		 */
		EClass USE = eINSTANCE.getUse();

		/**
		 * The meta object literal for the '<em><b>Owner</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference USE__OWNER = eINSTANCE.getUse_Owner();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute USE__NAME = eINSTANCE.getUse_Name();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.NatureImpl <em>Nature</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.NatureImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getNature()
		 * @generated
		 */
		EClass NATURE = eINSTANCE.getNature();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.QuantityImpl <em>Quantity</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.QuantityImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getQuantity()
		 * @generated
		 */
		EClass QUANTITY = eINSTANCE.getQuantity();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.BranchQuantityImpl <em>Branch Quantity</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.BranchQuantityImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getBranchQuantity()
		 * @generated
		 */
		EClass BRANCH_QUANTITY = eINSTANCE.getBranchQuantity();

		/**
		 * The meta object literal for the '<em><b>Plus terminal</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BRANCH_QUANTITY__PLUS_TERMINAL = eINSTANCE.getBranchQuantity_Plus_terminal();

		/**
		 * The meta object literal for the '<em><b>Minus terminal</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BRANCH_QUANTITY__MINUS_TERMINAL = eINSTANCE.getBranchQuantity_Minus_terminal();

		/**
		 * The meta object literal for the '<em><b>Through</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BRANCH_QUANTITY__THROUGH = eINSTANCE.getBranchQuantity_Through();

		/**
		 * The meta object literal for the '<em><b>Across</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BRANCH_QUANTITY__ACROSS = eINSTANCE.getBranchQuantity_Across();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VariableImpl <em>Variable</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VariableImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getVariable()
		 * @generated
		 */
		EClass VARIABLE = eINSTANCE.getVariable();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute VARIABLE__NAME = eINSTANCE.getVariable_Name();

		/**
		 * The meta object literal for the '<em><b>Owner</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VARIABLE__OWNER = eINSTANCE.getVariable_Owner();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.FunctionImpl <em>Function</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.FunctionImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getFunction()
		 * @generated
		 */
		EClass FUNCTION = eINSTANCE.getFunction();

		/**
		 * The meta object literal for the '<em><b>Return Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FUNCTION__RETURN_TYPE = eINSTANCE.getFunction_ReturnType();

		/**
		 * The meta object literal for the '<em><b>Parameter</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FUNCTION__PARAMETER = eINSTANCE.getFunction_Parameter();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FUNCTION__NAME = eINSTANCE.getFunction_Name();

		/**
		 * The meta object literal for the '<em><b>Sequential Statement</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FUNCTION__SEQUENTIAL_STATEMENT = eINSTANCE.getFunction_SequentialStatement();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ParameterImpl <em>Parameter</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ParameterImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getParameter()
		 * @generated
		 */
		EClass PARAMETER = eINSTANCE.getParameter();

		/**
		 * The meta object literal for the '<em><b>Owner Function</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PARAMETER__OWNER_FUNCTION = eINSTANCE.getParameter_OwnerFunction();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PARAMETER__NAME = eINSTANCE.getParameter_Name();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PARAMETER__TYPE = eINSTANCE.getParameter_Type();

		/**
		 * The meta object literal for the '<em><b>Default</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PARAMETER__DEFAULT = eINSTANCE.getParameter_Default();

		/**
		 * The meta object literal for the '<em><b>Owner Process</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PARAMETER__OWNER_PROCESS = eINSTANCE.getParameter_OwnerProcess();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.SequentialStatementImpl <em>Sequential Statement</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.SequentialStatementImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getSequentialStatement()
		 * @generated
		 */
		EClass SEQUENTIAL_STATEMENT = eINSTANCE.getSequentialStatement();

		/**
		 * The meta object literal for the '<em><b>Owner Function</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SEQUENTIAL_STATEMENT__OWNER_FUNCTION = eINSTANCE.getSequentialStatement_OwnerFunction();

		/**
		 * The meta object literal for the '<em><b>Owner Process</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SEQUENTIAL_STATEMENT__OWNER_PROCESS = eINSTANCE.getSequentialStatement_OwnerProcess();

		/**
		 * The meta object literal for the '<em><b>Sequential Statement</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SEQUENTIAL_STATEMENT__SEQUENTIAL_STATEMENT = eINSTANCE.getSequentialStatement_SequentialStatement();

		/**
		 * The meta object literal for the '<em><b>Owner Sequential Statement</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SEQUENTIAL_STATEMENT__OWNER_SEQUENTIAL_STATEMENT = eINSTANCE.getSequentialStatement_OwnerSequentialStatement();

		/**
		 * The meta object literal for the '<em><b>Predecessor</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SEQUENTIAL_STATEMENT__PREDECESSOR = eINSTANCE.getSequentialStatement_Predecessor();

		/**
		 * The meta object literal for the '<em><b>Successor</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SEQUENTIAL_STATEMENT__SUCCESSOR = eINSTANCE.getSequentialStatement_Successor();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.MapImpl <em>Map</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.MapImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getMap()
		 * @generated
		 */
		EClass MAP = eINSTANCE.getMap();

		/**
		 * The meta object literal for the '<em><b>Owner</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MAP__OWNER = eINSTANCE.getMap_Owner();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.GenericMapImpl <em>Generic Map</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.GenericMapImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getGenericMap()
		 * @generated
		 */
		EClass GENERIC_MAP = eINSTANCE.getGenericMap();

		/**
		 * The meta object literal for the '<em><b>From</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GENERIC_MAP__FROM = eINSTANCE.getGenericMap_From();

		/**
		 * The meta object literal for the '<em><b>To</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GENERIC_MAP__TO = eINSTANCE.getGenericMap_To();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ExpressionImpl <em>Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ExpressionImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getExpression()
		 * @generated
		 */
		EClass EXPRESSION = eINSTANCE.getExpression();

		/**
		 * The meta object literal for the '<em><b>Body</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EXPRESSION__BODY = eINSTANCE.getExpression_Body();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ConcurrentialStatementImpl <em>Concurrential Statement</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ConcurrentialStatementImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getConcurrentialStatement()
		 * @generated
		 */
		EClass CONCURRENTIAL_STATEMENT = eINSTANCE.getConcurrentialStatement();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.EquationImpl <em>Equation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.EquationImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getEquation()
		 * @generated
		 */
		EClass EQUATION = eINSTANCE.getEquation();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ProcessImpl <em>Process</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ProcessImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getProcess()
		 * @generated
		 */
		EClass PROCESS = eINSTANCE.getProcess();

		/**
		 * The meta object literal for the '<em><b>Parameter</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PROCESS__PARAMETER = eINSTANCE.getProcess_Parameter();

		/**
		 * The meta object literal for the '<em><b>Sequential Statement</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PROCESS__SEQUENTIAL_STATEMENT = eINSTANCE.getProcess_SequentialStatement();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROCESS__NAME = eINSTANCE.getProcess_Name();

		/**
		 * The meta object literal for the '<em><b>Variables</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PROCESS__VARIABLES = eINSTANCE.getProcess_Variables();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.IfThenStatementImpl <em>If Then Statement</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.IfThenStatementImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getIfThenStatement()
		 * @generated
		 */
		EClass IF_THEN_STATEMENT = eINSTANCE.getIfThenStatement();

		/**
		 * The meta object literal for the '<em><b>Boolean Expression</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute IF_THEN_STATEMENT__BOOLEAN_EXPRESSION = eINSTANCE.getIfThenStatement_BooleanExpression();

		/**
		 * The meta object literal for the '<em><b>Else</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference IF_THEN_STATEMENT__ELSE = eINSTANCE.getIfThenStatement_Else();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ElseStatementImpl <em>Else Statement</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ElseStatementImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getElseStatement()
		 * @generated
		 */
		EClass ELSE_STATEMENT = eINSTANCE.getElseStatement();

		/**
		 * The meta object literal for the '<em><b>If</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ELSE_STATEMENT__IF = eINSTANCE.getElseStatement_If();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ForStatementImpl <em>For Statement</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ForStatementImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getForStatement()
		 * @generated
		 */
		EClass FOR_STATEMENT = eINSTANCE.getForStatement();

		/**
		 * The meta object literal for the '<em><b>Loop Condition</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FOR_STATEMENT__LOOP_CONDITION = eINSTANCE.getForStatement_LoopCondition();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.StatementsImpl <em>Statements</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.StatementsImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getStatements()
		 * @generated
		 */
		EClass STATEMENTS = eINSTANCE.getStatements();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ProcessVariableImpl <em>Process Variable</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.ProcessVariableImpl
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getProcessVariable()
		 * @generated
		 */
		EClass PROCESS_VARIABLE = eINSTANCE.getProcessVariable();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROCESS_VARIABLE__NAME = eINSTANCE.getProcessVariable_Name();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PROCESS_VARIABLE__TYPE = eINSTANCE.getProcessVariable_Type();

		/**
		 * The meta object literal for the '<em><b>Default</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROCESS_VARIABLE__DEFAULT = eINSTANCE.getProcessVariable_Default();

		/**
		 * The meta object literal for the '<em><b>Owner Process</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PROCESS_VARIABLE__OWNER_PROCESS = eINSTANCE.getProcessVariable_OwnerProcess();

		/**
		 * The meta object literal for the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.PortDirection <em>Port Direction</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.PortDirection
		 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.impl.VhdlamsPackageImpl#getPortDirection()
		 * @generated
		 */
		EEnum PORT_DIRECTION = eINSTANCE.getPortDirection();

	}

} //VhdlamsPackage
