/*******************************************************************************
 * Copyright (c) 2014 Jean-Marie Gauthier and University of Franche-Comte
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Jean-Marie Gauthier and University of Franche-Comte - initial API and implementation
 *******************************************************************************/
package fr.femtost.disc.eclipse.sysml2problem.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

import fr.femtost.disc.eclipse.sysml2problem.ui.jobs.CheckJob;
import fr.femtost.disc.eclipse.sysml2problem.ui.utils.DisplayUtil;
import fr.femtost.disc.eclipse.sysml2problem.ui.utils.SelectionUtil;

public class CheckAction implements IObjectActionDelegate {

    private IFile selectedFile;

    @Override
    public final void run(final IAction action) {
        Job checkJob = new CheckJob(selectedFile);
        checkJob.addJobChangeListener(new JobChangeAdapter() {
            @Override
            public void done(final IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    DisplayUtil.updateStatusLine("Checking completed successfully");
                } else {
                    DisplayUtil.updateStatusLine("Could not complete the checking of the model due to error");
                }
            }
        });
        checkJob.setUser(true);
        checkJob.schedule();
    }

    @Override
    public final void selectionChanged(final IAction action, final ISelection selection) {
        selectedFile = SelectionUtil.findSelection(selection);
    }

    @Override
    public final void setActivePart(final IAction action, final IWorkbenchPart targetPart) {
    }
}
