/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.provider;

import fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.util.VhdlamsAdapterFactory;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class VhdlamsItemProviderAdapterFactory extends VhdlamsAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VhdlamsItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Entity} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EntityItemProvider entityItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Entity}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEntityAdapter() {
		if (entityItemProvider == null) {
			entityItemProvider = new EntityItemProvider(this);
		}

		return entityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Architecture} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArchitectureItemProvider architectureItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Architecture}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createArchitectureAdapter() {
		if (architectureItemProvider == null) {
			architectureItemProvider = new ArchitectureItemProvider(this);
		}

		return architectureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Element} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ElementItemProvider elementItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Element}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createElementAdapter() {
		if (elementItemProvider == null) {
			elementItemProvider = new ElementItemProvider(this);
		}

		return elementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Package} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PackageItemProvider packageItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Package}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPackageAdapter() {
		if (packageItemProvider == null) {
			packageItemProvider = new PackageItemProvider(this);
		}

		return packageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.VAModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VAModelItemProvider vaModelItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.VAModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVAModelAdapter() {
		if (vaModelItemProvider == null) {
			vaModelItemProvider = new VAModelItemProvider(this);
		}

		return vaModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Comment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CommentItemProvider commentItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Comment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCommentAdapter() {
		if (commentItemProvider == null) {
			commentItemProvider = new CommentItemProvider(this);
		}

		return commentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Terminal} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TerminalItemProvider terminalItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Terminal}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTerminalAdapter() {
		if (terminalItemProvider == null) {
			terminalItemProvider = new TerminalItemProvider(this);
		}

		return terminalItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Signal} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SignalItemProvider signalItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Signal}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignalAdapter() {
		if (signalItemProvider == null) {
			signalItemProvider = new SignalItemProvider(this);
		}

		return signalItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.QuantityPort} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected QuantityPortItemProvider quantityPortItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.QuantityPort}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createQuantityPortAdapter() {
		if (quantityPortItemProvider == null) {
			quantityPortItemProvider = new QuantityPortItemProvider(this);
		}

		return quantityPortItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Type} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeItemProvider typeItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Type}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTypeAdapter() {
		if (typeItemProvider == null) {
			typeItemProvider = new TypeItemProvider(this);
		}

		return typeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Constant} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConstantItemProvider constantItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Constant}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConstantAdapter() {
		if (constantItemProvider == null) {
			constantItemProvider = new ConstantItemProvider(this);
		}

		return constantItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Generic} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenericItemProvider genericItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Generic}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenericAdapter() {
		if (genericItemProvider == null) {
			genericItemProvider = new GenericItemProvider(this);
		}

		return genericItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.LibraryForVhdlAms} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LibraryForVhdlAmsItemProvider libraryForVhdlAmsItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.LibraryForVhdlAms}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLibraryForVhdlAmsAdapter() {
		if (libraryForVhdlAmsItemProvider == null) {
			libraryForVhdlAmsItemProvider = new LibraryForVhdlAmsItemProvider(this);
		}

		return libraryForVhdlAmsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ComponentInstanciation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComponentInstanciationItemProvider componentInstanciationItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ComponentInstanciation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComponentInstanciationAdapter() {
		if (componentInstanciationItemProvider == null) {
			componentInstanciationItemProvider = new ComponentInstanciationItemProvider(this);
		}

		return componentInstanciationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.PortMap} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PortMapItemProvider portMapItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.PortMap}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPortMapAdapter() {
		if (portMapItemProvider == null) {
			portMapItemProvider = new PortMapItemProvider(this);
		}

		return portMapItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Library} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LibraryItemProvider libraryItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Library}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLibraryAdapter() {
		if (libraryItemProvider == null) {
			libraryItemProvider = new LibraryItemProvider(this);
		}

		return libraryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Use} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UseItemProvider useItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Use}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUseAdapter() {
		if (useItemProvider == null) {
			useItemProvider = new UseItemProvider(this);
		}

		return useItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Nature} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NatureItemProvider natureItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Nature}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNatureAdapter() {
		if (natureItemProvider == null) {
			natureItemProvider = new NatureItemProvider(this);
		}

		return natureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Quantity} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected QuantityItemProvider quantityItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Quantity}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createQuantityAdapter() {
		if (quantityItemProvider == null) {
			quantityItemProvider = new QuantityItemProvider(this);
		}

		return quantityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.BranchQuantity} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BranchQuantityItemProvider branchQuantityItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.BranchQuantity}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBranchQuantityAdapter() {
		if (branchQuantityItemProvider == null) {
			branchQuantityItemProvider = new BranchQuantityItemProvider(this);
		}

		return branchQuantityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Variable} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VariableItemProvider variableItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Variable}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVariableAdapter() {
		if (variableItemProvider == null) {
			variableItemProvider = new VariableItemProvider(this);
		}

		return variableItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Function} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FunctionItemProvider functionItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Function}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFunctionAdapter() {
		if (functionItemProvider == null) {
			functionItemProvider = new FunctionItemProvider(this);
		}

		return functionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Parameter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ParameterItemProvider parameterItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Parameter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createParameterAdapter() {
		if (parameterItemProvider == null) {
			parameterItemProvider = new ParameterItemProvider(this);
		}

		return parameterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Map} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MapItemProvider mapItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Map}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMapAdapter() {
		if (mapItemProvider == null) {
			mapItemProvider = new MapItemProvider(this);
		}

		return mapItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.GenericMap} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenericMapItemProvider genericMapItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.GenericMap}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenericMapAdapter() {
		if (genericMapItemProvider == null) {
			genericMapItemProvider = new GenericMapItemProvider(this);
		}

		return genericMapItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Expression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExpressionItemProvider expressionItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Expression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExpressionAdapter() {
		if (expressionItemProvider == null) {
			expressionItemProvider = new ExpressionItemProvider(this);
		}

		return expressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ConcurrentialStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConcurrentialStatementItemProvider concurrentialStatementItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ConcurrentialStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConcurrentialStatementAdapter() {
		if (concurrentialStatementItemProvider == null) {
			concurrentialStatementItemProvider = new ConcurrentialStatementItemProvider(this);
		}

		return concurrentialStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Equation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EquationItemProvider equationItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Equation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEquationAdapter() {
		if (equationItemProvider == null) {
			equationItemProvider = new EquationItemProvider(this);
		}

		return equationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Process} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessItemProvider processItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Process}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessAdapter() {
		if (processItemProvider == null) {
			processItemProvider = new ProcessItemProvider(this);
		}

		return processItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.IfThenStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IfThenStatementItemProvider ifThenStatementItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.IfThenStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIfThenStatementAdapter() {
		if (ifThenStatementItemProvider == null) {
			ifThenStatementItemProvider = new IfThenStatementItemProvider(this);
		}

		return ifThenStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ElseStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ElseStatementItemProvider elseStatementItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ElseStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createElseStatementAdapter() {
		if (elseStatementItemProvider == null) {
			elseStatementItemProvider = new ElseStatementItemProvider(this);
		}

		return elseStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ForStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ForStatementItemProvider forStatementItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ForStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createForStatementAdapter() {
		if (forStatementItemProvider == null) {
			forStatementItemProvider = new ForStatementItemProvider(this);
		}

		return forStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Statements} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StatementsItemProvider statementsItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Statements}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStatementsAdapter() {
		if (statementsItemProvider == null) {
			statementsItemProvider = new StatementsItemProvider(this);
		}

		return statementsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ProcessVariable} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessVariableItemProvider processVariableItemProvider;

	/**
	 * This creates an adapter for a {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.ProcessVariable}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessVariableAdapter() {
		if (processVariableItemProvider == null) {
			processVariableItemProvider = new ProcessVariableItemProvider(this);
		}

		return processVariableItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (entityItemProvider != null) entityItemProvider.dispose();
		if (architectureItemProvider != null) architectureItemProvider.dispose();
		if (elementItemProvider != null) elementItemProvider.dispose();
		if (packageItemProvider != null) packageItemProvider.dispose();
		if (vaModelItemProvider != null) vaModelItemProvider.dispose();
		if (commentItemProvider != null) commentItemProvider.dispose();
		if (terminalItemProvider != null) terminalItemProvider.dispose();
		if (signalItemProvider != null) signalItemProvider.dispose();
		if (quantityPortItemProvider != null) quantityPortItemProvider.dispose();
		if (typeItemProvider != null) typeItemProvider.dispose();
		if (constantItemProvider != null) constantItemProvider.dispose();
		if (genericItemProvider != null) genericItemProvider.dispose();
		if (libraryForVhdlAmsItemProvider != null) libraryForVhdlAmsItemProvider.dispose();
		if (componentInstanciationItemProvider != null) componentInstanciationItemProvider.dispose();
		if (portMapItemProvider != null) portMapItemProvider.dispose();
		if (libraryItemProvider != null) libraryItemProvider.dispose();
		if (useItemProvider != null) useItemProvider.dispose();
		if (natureItemProvider != null) natureItemProvider.dispose();
		if (quantityItemProvider != null) quantityItemProvider.dispose();
		if (branchQuantityItemProvider != null) branchQuantityItemProvider.dispose();
		if (variableItemProvider != null) variableItemProvider.dispose();
		if (functionItemProvider != null) functionItemProvider.dispose();
		if (parameterItemProvider != null) parameterItemProvider.dispose();
		if (mapItemProvider != null) mapItemProvider.dispose();
		if (genericMapItemProvider != null) genericMapItemProvider.dispose();
		if (expressionItemProvider != null) expressionItemProvider.dispose();
		if (concurrentialStatementItemProvider != null) concurrentialStatementItemProvider.dispose();
		if (equationItemProvider != null) equationItemProvider.dispose();
		if (processItemProvider != null) processItemProvider.dispose();
		if (ifThenStatementItemProvider != null) ifThenStatementItemProvider.dispose();
		if (elseStatementItemProvider != null) elseStatementItemProvider.dispose();
		if (forStatementItemProvider != null) forStatementItemProvider.dispose();
		if (statementsItemProvider != null) statementsItemProvider.dispose();
		if (processVariableItemProvider != null) processVariableItemProvider.dispose();
	}

}
