
library IEEE;
use IEEE.electrical_systems.all;
use IEEE.math_real.all;


---------------- ENTITY DECLARATION VSIGNAL ----------------
ENTITY VSIGNAL IS
	GENERIC(
		ti : time;
		td : time
	);
	PORT(
		SIGNAL v_signal : OUT real
	);
END ENTITY VSIGNAL;

---------------- ARCHITECTURE DECLARATION behav OF VSIGNAL ----------------
ARCHITECTURE behav OF VSIGNAL IS
	

BEGIN
	
	
	
	v_signal <= 0.0 AFTER 0.0ms, 1.0 AFTER ti, 0.0 AFTER ti+td;
	
END ARCHITECTURE behav;


library IEEE;
use IEEE.electrical_systems.all;
use IEEE.math_real.all;


---------------- ENTITY DECLARATION Resistor ----------------
ENTITY Resistor IS
	GENERIC(
		res : real
	);
	PORT(
		TERMINAL m : Electrical;
		TERMINAL p : Electrical
	);
END ENTITY Resistor;

---------------- ARCHITECTURE DECLARATION behav OF Resistor ----------------
ARCHITECTURE behav OF Resistor IS
	QUANTITY v_in ACROSS i_out THROUGH p TO m;
	

BEGIN
	
	
	
	v_in == res * i_out;
	
END ARCHITECTURE behav;


library IEEE;
use IEEE.electrical_systems.all;
use IEEE.math_real.all;


---------------- ENTITY DECLARATION VCVsin ----------------
ENTITY VCVsin IS
	
	PORT(
		TERMINAL m : Electrical;
		TERMINAL p : Electrical;
		TERMINAL f : Electrical;
		TERMINAL a : Electrical
	);
END ENTITY VCVsin;

---------------- ARCHITECTURE DECLARATION behav OF VCVsin ----------------
ARCHITECTURE behav OF VCVsin IS
	CONSTANT twoPi : real := 6.283118530718;
	QUANTITY v_in ACROSS i_out THROUGH p TO m;
	QUANTITY v_f ACROSS f TO m;
	QUANTITY v_a ACROSS a TO m;
	

BEGIN
	
	
	
	v_in == v_a * sin (twoPi * v_f * now);
	
END ARCHITECTURE behav;


library IEEE;
use IEEE.electrical_systems.all;
use IEEE.math_real.all;

library work;
use work.ALL;
---------------- ENTITY DECLARATION RampSource ----------------
ENTITY RampSource IS
	GENERIC(
		v1 : real := 0.0;
		v2 : real := 1.0;
		intT : real := 1.0;
		ti : real;
		td : real
	);
	PORT(
		TERMINAL m : Electrical;
		TERMINAL p : Electrical
	);
END ENTITY RampSource;

---------------- ARCHITECTURE DECLARATION behav OF RampSource ----------------
ARCHITECTURE behav OF RampSource IS
	
	FUNCTION real2time(tt : real) RETURN time IS
	BEGIN
		return real(tt * 1.0e15) * 1 fs;
	END real2time;
	QUANTITY v_in ACROSS i_out THROUGH p TO m;
	QUANTITY vdot : real;
	
	SIGNAL v_signal :  real;

BEGIN
	
	Vsig : ENTITY VSIGNAL (behav) 
			GENERIC MAP (ti=>real2time(ti), td=>real2time(td))
			PORT MAP (v_signal=>v_signal);
	
	
	vdot'dot == v_signal / intT * (v2 - v1);
	
	v_in == v_signal * (vdot + v1);
	
END ARCHITECTURE behav;


library IEEE;
use IEEE.electrical_systems.all;
use IEEE.math_real.all;

library work;
use work.ALL;
---------------- ENTITY DECLARATION PolySource2 ----------------
ENTITY PolySource2 IS
	GENERIC(
		ti : real;
		td : real;
		a : real;
		b : real;
		c : real
	);
	PORT(
		TERMINAL m : Electrical;
		TERMINAL p : Electrical
	);
END ENTITY PolySource2;

---------------- ARCHITECTURE DECLARATION behav OF PolySource2 ----------------
ARCHITECTURE behav OF PolySource2 IS
	
	FUNCTION real2time(tt : real) RETURN time IS
	BEGIN
		return real(tt * 1.0e15) * 1 fs;
	END real2time;
	QUANTITY v_in ACROSS i_out THROUGH p TO m;
	QUANTITY vdot : real;
	QUANTITY tt : real;
	
	SIGNAL v_signal :  real;

BEGIN
	
	Vsig : ENTITY VSIGNAL (behav) 
			GENERIC MAP (ti=>real2time(ti), td=>real2time(td))
			PORT MAP (v_signal=>v_signal);
	
	
	vdot'dot == v_signal / td;
	
	tt == td * vdot + ti;
	
	v_in == v_signal * (a * tt * tt + b * tt + c);
	
END ARCHITECTURE behav;


library IEEE;
use IEEE.electrical_systems.all;
use IEEE.math_real.all;

library work;
use work.ALL;
---------------- ENTITY DECLARATION Vchirp ----------------
ENTITY Vchirp IS
	GENERIC(
		a1 : real := 1.0;
		a2 : real := 2.0;
		f1 : real := 50.0e6;
		f2 : real := 100.0e6;
		ti : real := 200.0;
		tau : real := 1.0
	);
	
END ENTITY Vchirp;

---------------- ARCHITECTURE DECLARATION behav OF Vchirp ----------------
ARCHITECTURE behav OF Vchirp IS
	
	TERMINAL nout : Electrical;
	TERMINAL nf : Electrical;
	TERMINAL na : Electrical;

BEGIN
	
	R1 : ENTITY Resistor (behav) 
			GENERIC MAP (res=>100.0e3)
			PORT MAP (p=>nout, m=>ground);
	Src : ENTITY VCVsin (behav) 
			PORT MAP (m=>ground, a=>na, f=>nf, p=>nout);
	dcf : ENTITY PolySource2 (behav) 
			GENERIC MAP (ti=>ti, td=>tau, a=>0.0, b=>(f2 - f1)/tau, c=>(f1*(ti+tau)-f2*ti)/tau)
			PORT MAP (m=>ground, p=>nf);
	DCA : ENTITY RampSource (behav) 
			GENERIC MAP (td=>tau, ti=>ti, v2=>a2, v1=>a1, intT=>tau)
			PORT MAP (m=>ground, p=>na);
	
	
END ARCHITECTURE behav;





