/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams;

import org.eclipse.emf.common.util.EList;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Sequential Statement</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getOwnerFunction <em>Owner Function</em>}</li>
 *   <li>{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getOwnerProcess <em>Owner Process</em>}</li>
 *   <li>{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getSequentialStatement <em>Sequential Statement</em>}</li>
 *   <li>{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getOwnerSequentialStatement <em>Owner Sequential Statement</em>}</li>
 *   <li>{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getPredecessor <em>Predecessor</em>}</li>
 *   <li>{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getSuccessor <em>Successor</em>}</li>
 * </ul>
 * </p>
 *
 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.VhdlamsPackage#getSequentialStatement()
 * @model abstract="true"
 * @generated
 */
public interface SequentialStatement extends Statement {
	/**
	 * Returns the value of the '<em><b>Owner Function</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Function#getSequentialStatement <em>Sequential Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Owner Function</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Owner Function</em>' container reference.
	 * @see #setOwnerFunction(Function)
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.VhdlamsPackage#getSequentialStatement_OwnerFunction()
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Function#getSequentialStatement
	 * @model opposite="sequentialStatement" transient="false"
	 * @generated
	 */
	Function getOwnerFunction();

	/**
	 * Sets the value of the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getOwnerFunction <em>Owner Function</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Owner Function</em>' container reference.
	 * @see #getOwnerFunction()
	 * @generated
	 */
	void setOwnerFunction(Function value);

	/**
	 * Returns the value of the '<em><b>Owner Process</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Process#getSequentialStatement <em>Sequential Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Owner Process</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Owner Process</em>' container reference.
	 * @see #setOwnerProcess(fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Process)
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.VhdlamsPackage#getSequentialStatement_OwnerProcess()
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Process#getSequentialStatement
	 * @model opposite="sequentialStatement" transient="false"
	 * @generated
	 */
	fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Process getOwnerProcess();

	/**
	 * Sets the value of the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getOwnerProcess <em>Owner Process</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Owner Process</em>' container reference.
	 * @see #getOwnerProcess()
	 * @generated
	 */
	void setOwnerProcess(fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.Process value);

	/**
	 * Returns the value of the '<em><b>Sequential Statement</b></em>' containment reference list.
	 * The list contents are of type {@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement}.
	 * It is bidirectional and its opposite is '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getOwnerSequentialStatement <em>Owner Sequential Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Sequential Statement</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Sequential Statement</em>' containment reference list.
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.VhdlamsPackage#getSequentialStatement_SequentialStatement()
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getOwnerSequentialStatement
	 * @model opposite="ownerSequentialStatement" containment="true"
	 * @generated
	 */
	EList<SequentialStatement> getSequentialStatement();

	/**
	 * Returns the value of the '<em><b>Owner Sequential Statement</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getSequentialStatement <em>Sequential Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Owner Sequential Statement</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Owner Sequential Statement</em>' container reference.
	 * @see #setOwnerSequentialStatement(SequentialStatement)
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.VhdlamsPackage#getSequentialStatement_OwnerSequentialStatement()
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getSequentialStatement
	 * @model opposite="sequentialStatement" transient="false"
	 * @generated
	 */
	SequentialStatement getOwnerSequentialStatement();

	/**
	 * Sets the value of the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getOwnerSequentialStatement <em>Owner Sequential Statement</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Owner Sequential Statement</em>' container reference.
	 * @see #getOwnerSequentialStatement()
	 * @generated
	 */
	void setOwnerSequentialStatement(SequentialStatement value);

	/**
	 * Returns the value of the '<em><b>Predecessor</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getSuccessor <em>Successor</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Predecessor</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Predecessor</em>' reference.
	 * @see #setPredecessor(SequentialStatement)
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.VhdlamsPackage#getSequentialStatement_Predecessor()
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getSuccessor
	 * @model opposite="successor"
	 * @generated
	 */
	SequentialStatement getPredecessor();

	/**
	 * Sets the value of the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getPredecessor <em>Predecessor</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Predecessor</em>' reference.
	 * @see #getPredecessor()
	 * @generated
	 */
	void setPredecessor(SequentialStatement value);

	/**
	 * Returns the value of the '<em><b>Successor</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getPredecessor <em>Predecessor</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Successor</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Successor</em>' reference.
	 * @see #setSuccessor(SequentialStatement)
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.VhdlamsPackage#getSequentialStatement_Successor()
	 * @see fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getPredecessor
	 * @model opposite="predecessor" required="true"
	 * @generated
	 */
	SequentialStatement getSuccessor();

	/**
	 * Sets the value of the '{@link fr.femtost.disc.eclipse.vhdlamsmetamodel.vhdlams.SequentialStatement#getSuccessor <em>Successor</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Successor</em>' reference.
	 * @see #getSuccessor()
	 * @generated
	 */
	void setSuccessor(SequentialStatement value);

} // SequentialStatement
