/*******************************************************************************
 * Copyright (c) 2014 Jean-Marie Gauthier and University of Franche-Comte
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Jean-Marie Gauthier and University of Franche-Comte - initial API and implementation
 *******************************************************************************/
package fr.femtost.disc.eclipse.sysml2problem.atl.transformation;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Map.Entry;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.m2m.atl.common.ATLExecutionException;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.IExtractor;
import org.eclipse.m2m.atl.core.IInjector;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.IReferenceModel;
import org.eclipse.m2m.atl.core.ModelFactory;
import org.eclipse.m2m.atl.core.emf.EMFExtractor;
import org.eclipse.m2m.atl.core.emf.EMFInjector;
import org.eclipse.m2m.atl.core.emf.EMFModelFactory;
import org.eclipse.m2m.atl.core.launch.ILauncher;
import org.eclipse.m2m.atl.engine.emfvm.launch.EMFVMLauncher;

/**
 * Entry point of the 'inModel2problem' transformation module.
 *
 * @generated not
 */
public class Sysml2problem {

    // USER refactor class name wrt your own transformation

    /**
     * The property file. Stores module list, the metamodel and library
     * locations.
     *
     * @generated not
     */
    private Properties properties;

	/**
	 * The INsysml model.
	 * @generated
	 */
	protected IModel insysmlModel;

				/**
	 * The INuml model.
	 * @generated
	 */
	protected IModel inumlModel;

				/**
	 * The INvhdlams model.
	 * @generated
	 */
	protected IModel invhdlamsModel;

				/**
	 * The OUT model.
	 * @generated
	 */
	protected IModel outModel;

				/**
	 * The main method.
	 * 
	 * @param args
	 *            are the arguments
	 * @generated
	 */
	public static void main(String[] args) {
		try {
			if (args.length < 4) {
				System.out.println("Arguments not valid : {INsysml_model_path, INuml_model_path, INvhdlams_model_path, OUT_model_path}.");
			} else {
				Sysml2problem runner = new Sysml2problem();
				runner.loadModels(args[0], args[1], args[2]);
				runner.doSysml2problem(new NullProgressMonitor());
				runner.saveModels(args[3]);
			}
		} catch (ATLCoreException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} catch (ATLExecutionException e) {
			e.printStackTrace();
		}
	}

	/**
     * The sysml model.
     *
     * @generated not
     */
    private IModel sysmlInstance;

	/**
     * The uml model.
     *
     * @generated not
     */
    protected IModel umlInstance;
    
    /**
     * The vhdl model.
     *
     * @generated not
     */
    protected IModel vhdlInstance;
    
    /**
     * The problem model.
     *
     * @generated not
     */
    private IModel problemInstance;

    /**
     * The main method.
     *
     * @param inModel         the input model to check
     * @param outModelProblem the problem instance generated
     * @throws IOException      if the input model does not exists
     * @throws ATLCoreException if the transformation fails
     * @generated not
     */
    public static void transform(final String inModel, final String outModelProblem) throws IOException, ATLCoreException {
        Sysml2problem runner = new Sysml2problem();
        runner.loadModels(inModel);
        runner.doSysml2problem(new NullProgressMonitor());
        runner.saveModels(outModelProblem);
    }

    /**
     * Constructor.
     *
     * @throws java.io.IOException if the properties file does not exists
     * @generated not
     */
    public Sysml2problem() throws IOException {
        properties = new Properties();
        InputStream isProp = getFileURL("Sysml2problem.properties").openStream();
        properties.load(isProp);
        isProp.close();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
    }

	/**
	 * Load the input and input/output models, initialize output models.
	 * 
	 * @param insysmlModelPath
	 *            the INsysml model path
	 * @param inumlModelPath
	 *            the INuml model path
	 * @param invhdlamsModelPath
	 *            the INvhdlams model path
	 * @throws ATLCoreException
	 *             if a problem occurs while loading models
	 *
	 * @generated
	 */
	public void loadModels(String insysmlModelPath, String inumlModelPath, String invhdlamsModelPath) throws ATLCoreException {
		ModelFactory factory = new EMFModelFactory();
		IInjector injector = new EMFInjector();
	 	IReferenceModel mmproblemMetamodel = factory.newReferenceModel();
		injector.inject(mmproblemMetamodel, getMetamodelUri("MMproblem"));
	 	IReferenceModel mmsysmlMetamodel = factory.newReferenceModel();
		injector.inject(mmsysmlMetamodel, getMetamodelUri("MMsysml"));
	 	IReferenceModel mmvhdlamsMetamodel = factory.newReferenceModel();
		injector.inject(mmvhdlamsMetamodel, getMetamodelUri("MMvhdlams"));
	 	IReferenceModel mmumlMetamodel = factory.newReferenceModel();
		injector.inject(mmumlMetamodel, getMetamodelUri("MMuml"));
		this.insysmlModel = factory.newModel(mmsysmlMetamodel);
		injector.inject(insysmlModel, insysmlModelPath);
		this.inumlModel = factory.newModel(mmumlMetamodel);
		injector.inject(inumlModel, inumlModelPath);
		this.invhdlamsModel = factory.newModel(mmvhdlamsMetamodel);
		injector.inject(invhdlamsModel, invhdlamsModelPath);
		this.outModel = factory.newModel(mmproblemMetamodel);
	}

	/**
     * Load the input and input/output models, initialize output models.
     *
     * @param modelPath the model model path
     * @throws ATLCoreException if a problem occurs while loading models
     * @generated not
     */
    private void loadModels(final String sysmlModelPath) throws ATLCoreException {
        ModelFactory factory = new EMFModelFactory();
        IInjector injector = new EMFInjector();
        IReferenceModel problemMetamodel = factory.newReferenceModel();
        injector.inject(problemMetamodel, getMetamodelUri("MMproblem"));
        IReferenceModel sysmlMetamodel = factory.newReferenceModel();
        injector.inject(sysmlMetamodel, getMetamodelUri("MMsysml"));
        IReferenceModel umlMetamodel = factory.newReferenceModel();
        injector.inject(umlMetamodel, getMetamodelUri("MMuml"));
        IReferenceModel mmvhdlamsMetamodel = factory.newReferenceModel();
		injector.inject(mmvhdlamsMetamodel, getMetamodelUri("MMvhdlams"));
        this.sysmlInstance = factory.newModel(sysmlMetamodel);
        injector.inject(sysmlInstance, sysmlModelPath);
        this.umlInstance = factory.newModel(umlMetamodel);
        injector.inject(umlInstance, sysmlModelPath);
        this.vhdlInstance = factory.newModel(mmvhdlamsMetamodel);
		injector.inject(vhdlInstance, "pathmap://VHDLAMS_LIBRARIES/ieee.vhdl.xmi");
        this.problemInstance = factory.newModel(problemMetamodel);
    }

    /**
     * Save the output and input/output models.
     *
     * @param problemModelPath the problem model path
     * @throws ATLCoreException if a problem occurs while saving models
     * @generated not
     */
    private void saveModels(final String problemModelPath) throws ATLCoreException {
        IExtractor extractor = new EMFExtractor();
        extractor.extract(problemInstance, problemModelPath);
    }

    /**
     * Transform the models.
     *
     * @param monitor the progress monitor
     * @return the result of the eclispe execution for the transformation
     * @throws ATLCoreException      if an error occurs during models handling
     * @throws IOException           if a module cannot be read
     * @throws ATLExecutionException if an error occurs during the execution
     * @generated not
     */
    private Object doSysml2problem(final IProgressMonitor monitor) throws ATLCoreException, IOException, ATLExecutionException {
        ILauncher launcher = new EMFVMLauncher();
        List<InputStream> inputStreamsToClose = new ArrayList<InputStream>();
        Map<String, Object> launcherOptions = getOptions();
        launcher.initialize(launcherOptions);
        launcher.addInModel(sysmlInstance, "INsysml", "MMsysml");
        launcher.addInModel(umlInstance, "INuml", "MMuml");
        launcher.addInModel(vhdlInstance, "INvhdlams", "MMvhdlams");
        launcher.addOutModel(problemInstance, "OUT", "MMproblem");
        InputStream[] modulesStreams = getModulesList();
        inputStreamsToClose.addAll(Arrays.asList(modulesStreams));
        Object result = launcher.launch(ILauncher.RUN_MODE, monitor,
                launcherOptions, (Object[]) modulesStreams);
        for (InputStream inputStream : inputStreamsToClose) {
            inputStream.close();
        }
        return result;
    }

    /**
     * Returns an Array of the module input streams, parameterized by the
     * property file.
     *
     * @return an Array of the module input streams
     * @throws IOException if a module cannot be read
     * @generated not
     */
    protected final InputStream[] getModulesList() throws IOException {
        InputStream[] modules = null;
        String modulesList = properties.getProperty("Sysml2problem.modules");
        if (modulesList != null) {
            String[] moduleNames = modulesList.split(",");
            modules = new InputStream[moduleNames.length];
            for (int i = 0; i < moduleNames.length; i++) {
                String asmModulePath = new Path(moduleNames[i].trim()).removeFileExtension().addFileExtension("asm").toString();
                modules[i] = getFileURL(asmModulePath).openStream();
            }
        }
        return modules;
    }

    /**
     * Returns the URI of the given metamodel, parameterized from the property
     * file.
     *
     * @param metamodelName the metamodel name
     * @return the metamodel URI
     * @generated not
     */
    protected final String getMetamodelUri(final String metamodelName) {
        return properties.getProperty(MessageFormat.format("Sysml2problem.metamodels.{0}", metamodelName));
    }

    /**
     * Returns the file name of the given library, parameterized from the
     * property file.
     *
     * @param libraryName the library name
     * @return the library file name
     * @throws java.io.IOException if the property file does not exists
     * @generated not
     */
    protected final InputStream getLibraryAsStream(final String libraryName)
            throws IOException {
        return getFileURL(properties.getProperty(MessageFormat.format("Sysml2problem.libraries.{0}", libraryName))).openStream();
    }

    /**
     * Returns the options map, parameterized from the property file.
     *
     * @return the options map
     * @generated not
     */
    protected final Map<String, Object> getOptions() {
        Map<String, Object> options = new HashMap<String, Object>();
        for (Entry<Object, Object> entry : properties.entrySet()) {
            if (entry.getKey().toString().startsWith("Sysml2problem.options.")) {
                options.put(entry.getKey().toString().replaceFirst("Sysml2problem.options.", ""),
                        entry.getValue().toString());
            }
        }
        return options;
    }

    /**
     * Finds the file in the plug-in. Returns the file URL.
     *
     * @param fileName the file name
     * @return the file URL
     * @throws IOException if the file doesn't exist
     * @generated not
     */
    protected static URL getFileURL(final String fileName) throws IOException {
        final URL fileURL;
        if (isEclipseRunning()) {
            URL resourceURL = Sysml2problem.class.getResource(fileName);
            if (resourceURL != null) {
                fileURL = FileLocator.toFileURL(resourceURL);
            } else {
                fileURL = null;
            }
        } else {
            fileURL = Sysml2problem.class.getResource(fileName);
        }
        if (fileURL == null) {
            throw new IOException(MessageFormat.format("''{0}'' not found", fileName));
        } else {
            return fileURL;
        }
    }

    /**
     * Tests if eclipse is running.
     *
     * @return <code>true</code> if eclipse is running
     * @generated not
     */
    private static boolean isEclipseRunning() {
        try {
            return Platform.isRunning();
        } catch (Throwable exception) {
            // Assume that we aren't running.
        }
        return false;
    }
}
