#!/usr/bin/env ruby
# encoding: UTF-8

class String
    def / other
        File.join(self, other)
    end
end

def mean(values)
    values.inject(:+) / values.size.to_f
end

def parse_output(file)
    values = Hash.new { |h, k| h[k] = [] }
    range = 0
    
    IO.foreach(file) do |line|
        case line
        when /range: (\d+)/
            range = $1
        when /pp_step/
            time = line.scan(/time\[(\d+)\]/).first.first.to_i
            values[range] << time
        end
    end
    
    p values
    
    results = Hash.new
    
    values.each do |k, v|
        p k, mean(v)
        results[k] = mean(v)
    end
    
    results
end

unless ARGV.size == 1
    $stderr.puts "Usage: #$0 <pp result dir>"
    exit 1
end

DEST_DIR = ARGV.first

cpu = parse_output(DEST_DIR / "perf_preypredator_cpu.txt")
gpu = parse_output(DEST_DIR / "perf_preypredator_gpu.txt")

output = DEST_DIR / "perfs.txt"

File.open(output, "w") do |out|
    cpu.each_key do |key|
        puts [key, cpu[key], gpu[key]].join(" ")
        out.puts [key, cpu[key], gpu[key]].join(" ")
    end
end 
