#!/usr/bin/env ruby
# encoding: UTF-8

FIELDS = ["pp_grass", "pp_move_preys", "pp_move_preds", "pp_step"]

stats = Hash.new

ARGF.each_line do |line|
    case line
    when /preypredator.PreyPredator2/
        puts "# #{line}"
        puts "# #{FIELDS.join(' ')}"
    when /org.perf4j.TimingLogger/
        tag  = line.scan(/tag\[(\w+)\]/).first[0]
        time = line.scan(/time\[(\d+)\]/).first[0].to_i
        
        next if tag == "axb_transform" || tag =~ /^gridsearch_/
        
        stats[tag] = time
        
        if tag == "pp_step"
            puts stats.values_at(*FIELDS).join(" ")
            stats.clear
        end
        
        #puts "#{tag}: #{time}"
    end
end
