#!/bin/bash

if [ $# -ne 1 -o ! -d "$1" ]; then
    echo "Usage: $0 <results directory>"
    exit 1
fi

RESULTS="$1"
PLOT_DIR="$(pwd)"

cd $RESULTS

for f in results_gpu6.txt results_gpu7.txt; do
    mv -v $f $f.old
    grep -v PacketSize $f.old > $f
done

echo "Plotting performances for $RESULTS"
gnuplot $PLOT_DIR/mior_perfs_para.plt

#for model in cpu gpu2 gpu3 gpu4 gpu5; do
#    for scale in $(seq 1 30); do
#	    input="data_${model}_${scale}.txt"
#	    echo "Plotting results for $input"
#	    gnuplot -e "call \"$PLOT_DIR/mior.plt\" \"$input\" \"${model}_${scale}\""
#    done
