#!/bin/bash

. "${BASH_SOURCE%/*}/common.sh"

if [ $# -lt 1 ]; then
    echo "Usage: $0 <directory>"
    exit 1
fi

DEST_DIR="$1"

if [ ! -d $DEST_DIR ]; then
    mkdir -p $DEST_DIR
fi

cat /etc/issue            > $DEST_DIR/platform_issue
uname -a                  > $DEST_DIR/platform_kernel
cat /proc/cpuinfo         > $DEST_DIR/platform_cpuinfo
free -m                   > $DEST_DIR/platform_memory
$JAVA mcmas.core.MCMUtils > $DEST_DIR/platform_opencl
