#!/bin/bash

CLASSPATH="build/jar/mcmas.jar:lib/*:lib/"
JAVA_OPTIONS+="-classpath $CLASSPATH"

# Make the JVM more verbose
# JAVA_OPTIONS+=" -verbose:gc -verbose:jni"

# Control OpenCL profiling
# export OPENCL_PROFILE=1
# export OPENCL_PROFILE_CONFIG=profiler_config.txt

TOTAL_MEMORY=$(free -m | grep 'Mem:' | awk '{print $2}')
JAVA_MEMORY=$(echo "0.8 * $TOTAL_MEMORY" | bc | cut -d. -f1)

#echo $TOTAL_MEMORY
#echo $JAVA_MEMORY

JAVA_OPTIONS+=" -Xmx${JAVA_MEMORY}m"

JAVA="java $JAVA_OPTIONS"
