#!/bin/bash

# BENCHMARK SETTINGS

RUN_COMMAND=utils/run.sh
BATCH_SIZE=20

# ACTUAL CODE

BENCH_DATE=$(date "+%Y%m%d_%H%M%S")
DEST_DIR="results_para_size/$BENCH_DATE"
PREFIX=""

if [ ! -d $DEST_DIR ]; then
    echo "=> Creating results directory ${DEST_DIR}"
    mkdir -p $DEST_DIR
fi

echo $0 > $DEST_DIR/cmd

function run_gpu_sim()
{
    local totalSize=$1
    local kernelSize=$2
    local version=$3
    local data="${DEST_DIR}/data_gpu${version}_${nbSimulations}.txt"
    local output="${DEST_DIR}/results_gpu${version}.txt"

    $RUN_COMMAND -b $BATCH_SIZE -n $totalSize --ks $kernelSize -o $data -v $version -p $kernelSize >> $output
}

function run_all_sims()
{
    local batchSize=$1
    local nbSimulations=$2

    echo "## SIZE $nbSimulations ##"

    echo "== GPU v6.0 =="
    run_gpu_sim $batchSize $nbSimulations 6

	  echo "== GPU v7.0 =="
	  run_gpu_sim $batchSize $nbSimulations 7
}

#for mul in $(seq 1 100); do
for i in $(seq 1 10) $(seq 20 10 100); do
	run_all_sims 10000 $mul
done

touch $DEST_DIR/finished
