#!/bin/bash

# BENCHMARK SETTINGS

RUN_COMMAND=utils/run.sh
BATCH_SIZE=50

# ACTUAL CODE

BENCH_DATE=$(date "+%Y%m%d_%H%M%S")
DEST_DIR="results_para/$BENCH_DATE"
PREFIX=""

if [ ! -d $DEST_DIR ]; then
    echo "=> Creating results directory ${DEST_DIR}"
    mkdir -p $DEST_DIR
fi

function run_gpu_sim()
{
    local batchSize=$1
    local nbSimulations=$2
    local version=$3
    local data="${DEST_DIR}/data_gpu${version}_${nbSimulations}.txt"
    local output="${DEST_DIR}/results_gpu${version}.txt"
    
    $RUN_COMMAND -b $batchSize -n $nbSimulations -o $data -v $version -p $nbSimulations | tee -a $output
}

function run_all_sims()
{
    local batchSize=$1
    local nbSimulations=$2

    echo "## SIZE $nbSimulations ##"

    echo "== GPU v6.0 =="
    run_gpu_sim $batchSize $nbSimulations 6

	echo "== GPU v7.0 =="
	run_gpu_sim $batchSize $nbSimulations 7
}

for mul in $(seq 1 100); do
	run_all_sims $BATCH_SIZE $mul
done

touch $DEST_DIR/finished
