#!/bin/bash

# BENCHMARK SETTINGS

RUN_COMMAND=utils/run.sh
BATCH_SIZE=50

# ACTUAL CODE

BENCH_DATE=$(date "+%Y%m%d_%H%M%S")
DEST_DIR="results/$BENCH_DATE"
PREFIX=""

if [ ! -d $DEST_DIR ]; then
    echo "=> Creating results directory ${DEST_DIR}"
    mkdir -p $DEST_DIR
fi

function run_cpu_sim()
{
    local scale=$1
    local data="${DEST_DIR}/data_cpu_${scale}.txt"
    local output="${DEST_DIR}/results_cpu.txt"
    
    $RUN_COMMAND -n $BATCH_SIZE -s $scale -o $data -j -p $scale | tee -a $output
}

function run_gpu_sim()
{
    local scale=$1
    local version=$2
    local data="${DEST_DIR}/data_gpu${version}_${scale}.txt"
    local output="${DEST_DIR}/results_gpu${version}.txt"
    
    $RUN_COMMAND -n $BATCH_SIZE -s $scale -o $data -v $version -p $scale | tee -a $output
}

function run_all_sims()
{
    local scale=$1
    
    echo "## SCALE $scale ##"
    
    echo "== CPU =="
    run_cpu_sim $scale
    
    echo "== GPU v2.0 =="
    run_gpu_sim $scale 2
    
    echo "== GPU v3.0 =="
    run_gpu_sim $scale 3
    
    echo "== GPU v4.0 =="
    run_gpu_sim $scale 4
    
     echo "== GPU v5.0 =="
    run_gpu_sim $scale 5
}

for scale in $(seq 1 30); do
    run_all_sims $scale
done
