#!/bin/bash

RUN_COMMAND="utils/run_preypredator.sh"
BENCH_DATE=$(date "+%Y%m%d_%H%M%S")
DEST_DIR="results_pp/$BENCH_DATE"

if [ ! -d $DEST_DIR ]; then
    echo "=> Creating results directory ${DEST_DIR}"
    mkdir -p $DEST_DIR
fi

# Store platform informations
utils/mcmas/infos.sh $DEST_DIR

OUTPUT_CPU="$DEST_DIR/perf_preypredator_cpu.txt"
OUTPUT_GPU="$DEST_DIR/perf_preypredator_gpu.txt"

for i in $(seq 10 5 100); do

    echo "# $@" >> $OUTPUT_CPU
    echo "# RANGE: $r" >> $OUTPUT_CPU
    $RUN_COMMAND --gpu false --range $i &>> $OUTPUT_CPU
	
    echo "# $@" >> $OUTPUT_GPU
    echo "# RANGE: $r" >> $OUTPUT_GPU
    $RUN_COMMAND --gpu true  --range $i &>> $OUTPUT_GPU
    
done
