#!/bin/bash

# BENCHMARK SETTINGS

RUN_COMMAND=utils/run.sh
NB_TIMES=20

# ACTUAL CODE

BENCH_DATE=$(date "+%Y%m%d_%H%M%S")
DEST_DIR="results_para_size/$BENCH_DATE"
PREFIX=""

if [ ! -d $DEST_DIR ]; then
    echo "=> Creating results directory ${DEST_DIR}"
    mkdir -p $DEST_DIR
fi

echo $0 > $DEST_DIR/cmd

# Store platform informations


utils/mcmas/infos.sh $DEST_DIR

function run_gpu_sim()
{
    local kernelSize=$1
    local nbSimulations=$2
    local version=$3
    local data="${DEST_DIR}/data_gpu${version}_${nbSimulations}.txt"
    local output="${DEST_DIR}/results_gpu${version}.txt"
    
    # Run N simulations in (N / kernelSize) steps
    $RUN_COMMAND --repeat $NB_TIMES --nbSimulations $nbSimulations \
    --kernelSize $groupSize --output $data --version $version --prefix $kernelSize >> $output
}

function run_all_sims()
{
    local groupSize=$2
    local nbSimulations=$1

    echo "## SIZE $nbSimulations (groupSize: $groupSize) ##"

    echo "== GPU v6.0 =="
    run_gpu_sim $groupSize $nbSimulations 6

    echo "== GPU v7.0 =="
    run_gpu_sim $groupSize $nbSimulations 7
}

for groupSize in $(seq 1 10) $(seq 20 10 100); do
	run_all_sims 10000 $groupSize
done

touch $DEST_DIR/finished
