#!/bin/bash

# BENCHMARK SETTINGS

RUN_COMMAND=utils/run.sh
NB_TIMES=50

# ACTUAL CODE

BENCH_DATE=$(date "+%Y%m%d_%H%M%S")
DEST_DIR="results_para/$BENCH_DATE"
PREFIX=""

if [ ! -d $DEST_DIR ]; then
    echo "=> Creating results directory ${DEST_DIR}"
    mkdir -p $DEST_DIR
fi

# Store platform informations
utils/mcmas/infos.sh $DEST_DIR

function run_gpu_sim()
{
    local nbTimes=$1
    local nbSimulations=$2
    local version=$3
    local data="${DEST_DIR}/data_gpu${version}_${nbSimulations}.txt"
    local output="${DEST_DIR}/results_gpu${version}.txt"
    
    # Run N simulations in one go (nbSimulations == kernelSize)
    $RUN_COMMAND --repeat $nbTimes --nbSimulations $nbSimulations \
    --kernelSize $nbSimulations --output $data --version $version \
    --prefix $nbSimulations | tee -a $output
}

function run_all_sims()
{
    local nbTimes=$1
    local nbSimulations=$2

    echo "## SIZE $nbSimulations ##"

    echo "== GPU v6.0 =="
    run_gpu_sim $nbTimes $nbSimulations 6

	echo "== GPU v7.0 =="
	run_gpu_sim $nbTimes $nbSimulations 7
	
#	echo "== GPU v9.0 =="
#	run_gpu_sim $nbTimes $nbSimulations 9
}

for mul in $(seq 1 100); do
	run_all_sims $NB_TIMES $mul
done

touch $DEST_DIR/finished
