#!/bin/bash

RUN_COMMAND="utils/run_collem.sh"
BENCH_DATE=$(date "+%Y%m%d_%H%M%S")
DEST_DIR="results_collem/$BENCH_DATE"

if [ ! -d $DEST_DIR ]; then
    echo "=> Creating results directory ${DEST_DIR}"
    mkdir -p $DEST_DIR
fi

# Store platform informations
utils/mcmas/infos.sh $DEST_DIR

PERFS_OUTPUT="$DEST_DIR/perf_collem_$BENCH_DATE.txt"

for i in $(seq 1 25); do
    OUTPUT="$DEST_DIR/output_collem_$BENCH_DATE_$i.txt"
    echo "# $@" >> $OUTPUT
    
	$RUN_COMMAND -n 500 --scale $i &>> $OUTPUT
	
	# Filter full output to only keep performance-related informations
	echo -n "$i " >> $PERFS_OUTPUT
	grep 'platform name' $OUTPUT | sed -e 's/^/# /' >> $PERFS_OUTPUT
	grep 'platform vendor' $OUTPUT | sed -e 's/^/# /' >> $PERFS_OUTPUT
	grep 'totalTime' $OUTPUT | cut -d' ' -f10 >> $PERFS_OUTPUT
done
