package preypredator;

import mcmas.api.MCMASContext;
import mcmas.core.MCMCommandQueueProperty;
import mcmas.plugins.axb.AXBPlugin;
import mcmas.plugins.gridsearch.GridSearchPlugin;


public class PPRuntimeGPU implements PPRuntime {
	
	private final MCMASContext context;
	private final AXBPlugin axbPlugin;
	private final GridSearchPlugin searchPlugin;
	
	public PPRuntimeGPU() {
		this.context = new MCMASContext(MCMCommandQueueProperty.ENABLE_PROFILING);
		this.axbPlugin = new AXBPlugin(context);
		this.searchPlugin = new GridSearchPlugin(context);
	}
	
	@Override
	public void growGrass(PPGrid grass, float factor, int growth, int min, int max) {
		axbPlugin.clampedTransform(grass.getStorage(), factor, growth, min, max);
	}
	
	@Override
	public void selectMaxTarget(PPGrid grid, int radius, int[] xPositions,
			int[] yPositions, int[] newXPositions,
			int[] newYPositions) {
		searchPlugin.findMaxCell(grid, radius, xPositions, yPositions, newXPositions, newYPositions);
	}
	
	@Override
	public void selectNearestNonZeroTarget(PPGrid grid, int radius,
			int[] xPositions, int[] yPositions, int[] newXPositions,
			int[] newYPositions) {
		// TODO Auto-generated method stub
	}

}
