package preypredator;

public class PPRuntimeCPU implements PPRuntime {
	
	@Override
	public void growGrass(PPGrid grass, float factor, int growth, int min, int max) {
		final int[] storage = grass.getStorage();
		
		for (int i = 0; i < storage.length; i++) {
			storage[i] = Math.max(min, Math.max(max, (int) (factor * storage[i] + growth)));
		}
	}
	
	@Override
	public void selectMaxTarget(PPGrid grid, int radius, int[] xPositions,
			int[] yPositions, int[] newXPositions, int[] newYPositions) {
		
		PPTargetFilter maxFilter = new PPTargetFilter() {
			
			private int max = Integer.MIN_VALUE;
			
			@Override
			public boolean examineTarget(int x, int y, int value) {
				if (value > max) {
					this.max = value;
					this.x = x;
					this.y = y;
				}
				return false;
			}
		};
		
		selectTarget(grid, radius, maxFilter, xPositions, yPositions, newXPositions, newYPositions);
	}
	
	@Override
	public void selectNearestNonZeroTarget(PPGrid grid, int radius,
			int[] xPositions, int[] yPositions, int[] newXPositions,
			int[] newYPositions) {
		
		PPTargetFilter nonZeroFilter = new PPTargetFilter() {
			
			@Override
			public boolean examineTarget(int x, int y, int value) {
				if (value != 0) {
					this.x = x;
					this.y = y;
					return true;
				}
				
				return false;
			}
		};
		
		selectTarget(grid, radius, nonZeroFilter, xPositions, yPositions, newXPositions, newYPositions);
	}
	
	public void selectTarget(PPGrid grid, int radius, PPTargetFilter filter, int[] xPositions,
			int[] yPositions, int[] newXPositions, int[] newYPositions) {
		
		for (int index = 0; index < xPositions.length; index++) {
			final int x = xPositions[index];
			final int y = yPositions[index];
			
			int i = -1;
			int j = -1;
			boolean finished = false;
			
			for (int r = 1; r <= radius; r++) {
			
			    j = y - r;
			    for (i = x - r; i < x + r; i++) {
			    	if (i < 0 || i >= grid.getWidth() || j < 0 || j >= grid.getHeight()) {
			    		continue;
			    	}
			    	
			    	finished = filter.examineTarget(i, j, grid.get(i, j));
			    	if (finished) break;
			    }
	
			    i = x + r;
			    for (j = y - r; j < y + r; j++) {
			    	if (i < 0 || i >= grid.getWidth() || j < 0 || j >= grid.getHeight()) {
			    		continue;
			    	}
			    	
			    	finished = filter.examineTarget(i, j, grid.get(i, j));
			    	if (finished) break;
			    }
	
			    j = y + r;
			    for (i = x + r; i > x - r; i--) {
			    	if (i < 0 || i >= grid.getWidth() || j < 0 || j >= grid.getHeight()) {
			    		continue;
			    	}
			    	
			    	finished = filter.examineTarget(i, j, grid.get(i, j));
			    	if (finished) break;
			    }
	
			    i = x - r;
			    for (j = y + r; j > y - r; j--) {
			    	if (i < 0 || i >= grid.getWidth() || j < 0 || j >= grid.getHeight()) {
			    		continue;
			    	}
			    	
			    	finished = filter.examineTarget(i, j, grid.get(i, j));
			    	if (finished) break;
			    }
			    
			    if (finished) break;
			}
			
			newXPositions[index] = filter.x;
			newYPositions[index] = filter.y;
		}
	}

}
