package mior.view;

import java.awt.BorderLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

import mior.controler.AutoLiveAction;
import mior.controler.ClearAction;
import mior.controler.ConfigureAssociationsAction;
import mior.controler.ConfigureRadiusAction;
import mior.controler.ConfigureRandomAction;
import mior.controler.LiveAction;
import mior.controler.ResetAction;
import mior.controler.TopoAction;
import mior.model.IMiorModel;
import mior.model.MiorWorld;
import mior.model.OCLMiorModel;

public class MiorView {

	private IMiorModel model;
	private final JFrame frame;
	private final MiorCanvas canvas;
	private final MiorGraph graph;
	
	public MiorView(IMiorModel model) {
		this(model, "");
	}
	
	public MiorView(IMiorModel model, String suppl) {
		this.frame = new JFrame("MiorCL - 0.2 [" + suppl + "]");
		this.model = model;
		
		this.canvas = new MiorCanvas(model);
		model.addUpdateListener(canvas);
		
		this.graph = new MiorGraph();
		model.addUpdateListener(graph);
		
		buildUI();
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setVisible(true);
		frame.pack();
	}
	
	public void setModel(IMiorModel model) {
		if (model != this.model) {
			model.addUpdateListener(canvas);
			model.addUpdateListener(graph);
		}
		
		this.model = model;
	}
	
	public JFrame getFrame() {
		return frame;
	}
	
	private void buildUI() {
		final JPanel mainPanel = new JPanel(new BorderLayout());
		frame.setContentPane(mainPanel);

		mainPanel.add(canvas, BorderLayout.CENTER);
		mainPanel.add(graph, BorderLayout.EAST);
		
		final JPanel buttonPanel = new JPanel();
		mainPanel.add(buttonPanel, BorderLayout.SOUTH);
		
		final JButton resetButton = new JButton(new ResetAction(model));
		buttonPanel.add(resetButton);

		final JButton topoButton = new JButton(new TopoAction(model));
		buttonPanel.add(topoButton);

		final JButton liveButton = new JButton(new LiveAction(model));
		buttonPanel.add(liveButton);

		final JButton autoButton = new JButton(new AutoLiveAction(model));
		buttonPanel.add(autoButton);
		
		final JButton clearButton = new JButton(new ClearAction(graph));
		buttonPanel.add(clearButton);
		
		final JCheckBox assocCheckbox = new JCheckBox(new ConfigureAssociationsAction(canvas));
		assocCheckbox.setSelected(canvas.isAssociationsVisible());
		buttonPanel.add(assocCheckbox);

		final JCheckBox radiusCheckbox = new JCheckBox(new ConfigureRadiusAction(canvas));
		radiusCheckbox.setSelected(canvas.isRadiusVisible());
		buttonPanel.add(radiusCheckbox);

		final JCheckBox randomCheckBox = new JCheckBox(new ConfigureRandomAction(model));
		randomCheckBox.setSelected(model.isRandomEnabled());
		buttonPanel.add(randomCheckBox);
	}

	public static void main(String[] args) {
		SwingUtilities.invokeLater(new Runnable() {

			@Override
			public void run() {
				try {
					UIManager.setLookAndFeel(UIManager
							.getSystemLookAndFeelClassName());
				} catch (final Exception e) {
					e.printStackTrace();
				}
				final MiorWorld world = new MiorWorld(1);
				final IMiorModel model = new OCLMiorModel(world);
				new MiorView(model);
			}

		});
	}
}
