package mior.view;

import javax.swing.BoxLayout;
import javax.swing.JPanel;

import mior.model.IMiorModel;
import mior.model.IMiorUpdateListener;
import mior.model.MiorMM;
import mior.model.MiorOM;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public class MiorGraph extends JPanel implements IMiorUpdateListener {
	
	private static final long serialVersionUID = 1L;
	
	private final DefaultCategoryDataset data1;
	private final DefaultCategoryDataset data2;
	private int lastCO2 = 0;
	private int step;
	
	public MiorGraph() {
		setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));
		
		data1 = new DefaultCategoryDataset();
		data2 = new DefaultCategoryDataset();
		
		final JFreeChart chart1 = ChartFactory.createLineChart(
				"Agents numbers",
				"Step",
				"Value",
				data1,
				PlotOrientation.VERTICAL,
				true,
				true,
				false
				);
		
		ChartPanel panel1 = new ChartPanel(chart1);
		add(panel1);
		
		final JFreeChart chart2 = ChartFactory.createLineChart(
				"Carbon summary",
				"Step",
				"Value (thousands)",
				data2,
				PlotOrientation.VERTICAL,
				true,
				true,
				false
				);
		
		ChartPanel panel2 = new ChartPanel(chart2);
		add(panel2);
		
		clear();
	}
	
	public void update(IMiorModel model) {
		final String stepLabel = Integer.toString(step);
		
		data1.addValue(model.getWorld().nbMM, "MM", stepLabel);
		
		int nbActifs = 0;
		int MMtotalC = 0;
		int OMtotalC = 0;
		final int CO2 = model.getWorld().CO2;
			
		for (MiorMM mm : model.getMMList()) {
			MMtotalC += mm.getCarbone();
			/*if (mm.getCarbone() < 0) {
				System.out.println("MM oops");
			}*/
			if (mm.dormance == 0) {
				nbActifs++;
			}
		}
		
		for (MiorOM om : model.getOMList()) {
			OMtotalC += om.getCarbone();
			/*if (om.getCarbone() < 0) {
				System.out.println("OM oops");
			}*/
		}
		
		data1.addValue(nbActifs, "MM Actifs", stepLabel);
		
		data2.addValue(MMtotalC / 1000, "CMM", stepLabel);
		data2.addValue(OMtotalC / 1000, "COM", stepLabel);
		data2.addValue(CO2 / 1000, "CO2", stepLabel);
		data2.addValue((CO2 + MMtotalC + OMtotalC) / 1000, "Total", stepLabel);
		
		// TODO : HACK FOR MULTIPLE EXECUTIONS
		lastCO2 = Math.min(CO2, lastCO2);
			
		data2.addValue((CO2 - lastCO2) / 100, "dCO2 (x10)", stepLabel);
		lastCO2 = CO2;
		step++;
	}
	
	public void clear() {
		lastCO2 = 0;
		step = 0;
		data1.clear();
		data2.clear();
	}
	
	@Override
	public void onMiorModelUpdated(IMiorModel model) {
		update(model);
		repaint();
	}
}

