package mior.model.multi;

import mcmas.core.MCMCommandQueue;
import mcmas.core.MCMContext;
import mcmas.core.MCMDevice;

public class OCLScheduler {
	
	private MCMContext context;
	private MCMDevice[] devices;
	private MCMCommandQueue[] queues;
	
	public OCLScheduler(MCMContext context) {
		this.context = context;
		this.devices = context.getDevices();
		this.queues = new MCMCommandQueue[devices.length];
		
		for (int i = 0; i < queues.length; i++) {
			queues[i] = context.createCommandQueue(devices[i]);
		}
	}
	
	public void run(OCLTask task) {
		task.run(context, queues[0]);
	}
	
}
