package mior.model.dist;

public class PoissonDistribution extends AbstractMiorDistribution {
	
	private final int minOM;
	private final int maxOM;
	private final double lambda;
	
	public PoissonDistribution(int meanMM, int meanOM, double variation) {
		super(meanMM, meanOM);
		minOM = (int) ((1.0 - variation) * meanOM);
		maxOM = (int) ((1.0 + variation) * meanOM);
		this.lambda = (maxOM - minOM) / 2.0;
	}
	
	@Override
	public double getFactor() {
		throw new UnsupportedOperationException();
		/*final double L = Math.exp(-lambda);
		int k = 0;
		double p = 1;
		
		do {
			k += 1;
			p *= Math.random();
		} while (p > L);
		
		return (minOM + k);*/
	}
	
	@Override
	public double getMaxFactor() {
		throw new UnsupportedOperationException();
	}
	
}
