package mior.model.dist;

import java.util.Random;

public class LinearDistribution extends AbstractMiorDistribution {
	
	private final double variation;
	private final Random rng;
	
	public LinearDistribution(int meanMM, int meanOM, double variation) {
		super(meanMM, meanOM);
		this.variation = variation;
		this.rng = new Random();
	}
	
	@Override
	public double getFactor() {
		return 1 + (2 * rng.nextFloat() - 1) * variation;
	}
	
	@Override
	public double getMaxFactor() {
		return 1.0 + variation;
	}
	
}
