package mior.model;

public abstract class SimpleMiorModel extends AbstractMiorModel {
	
	protected final int nbMM;
	protected final int nbOM;
	
	protected final MiorMM [] mmList;
	protected final MiorOM [] omList;
	protected final int [] associations;
	protected MiorWorld world;
	
	/*public SimpleMiorModel(int nbMM, int nbOM) {
		this(nbMM, nbOM, nbMM * nbOM);
	}*/
	
	/*
	public SimpleMiorModel(int nbMM, int nbOM, int associationsSize) {
		super();
		this.nbMM = nbMM;
		this.nbOM = nbOM;
		this.mmList = new MiorMM[nbMM];
		this.omList = new MiorOM[nbOM];
		this.associations = new int[associationsSize];
		this.world = new MiorWorld(nbMM, nbOM);
		init(nbMM, nbOM);
	}*/
	
	public SimpleMiorModel(MiorWorld world) {
		this.world = world;
		this.nbMM = world.nbMM;
		this.nbOM = world.nbOM;
		
		this.mmList = new MiorMM[nbMM];
		this.omList = new MiorOM[nbOM];
		this.associations = new int[nbMM * nbOM];
		init(nbMM, nbOM);
	}
	
	private void init(int nbMM, int nbOM) {
		MiorUtils.initRandomMMArray(mmList, world.width);
		MiorUtils.initRandomOMArray(omList, world.width);
		MiorUtils.initAssociations(associations);
		world = new MiorWorld(world);
	}
	
	@Override
	public final MiorMM[] getMMList() {
		return mmList;
	}
	
	@Override
	public final MiorOM[] getOMList() {
		return omList;
	}
	
	@Override
	public final MiorWorld getWorld() {
		return world;
	}
	
	@Override
	public int getNbSimulations() {
		return 1;
	}
	
	@Override
	public final boolean isAccessible(int iMM, int iOM) {
		return isAccessible(iMM, iOM, 0);
	}
	
	@Override
	public boolean isAccessible(int iMM, int iOM, int iSim) {
		return associations[iMM * nbOM + iOM] != -1;
	}
	
	@Override
	protected void resetImpl() {
		init(world.nbMM, world.nbOM);
	}
	
}
