package mior.model;

import org.jocl.struct.Struct;

public class MiorWorld extends Struct {
	
	private final double scale;
	
	public int   nbMM            = 38; //38; //72; //38;
	public int   nbOM            = 310; //310; //620; //310;
	public int   RA              = 6; //400; // 150
	public float RR              = 0.1f; // 0.1
	public float GR              = 0.1f; // 0.1
	public float K               = 0.25f; // 0.5
	
	public int   width           = 35; //00; // 1000
	public int   minSize         = 0;
	public int   CO2             = 0;
	public int   lock            = -1;
	
	public MiorWorld(int nbMM, int nbOM) {
		this(nbMM, nbOM, 1);
	}
	
	public MiorWorld(double scale) {
		this(38, 310, scale);
	}
	
	public MiorWorld(int nbMM, int nbOM, double scale) {
		//System.out.println(scale);
		this.scale = scale;
		this.nbMM = (int) (scale * nbMM);
		this.nbOM = (int) (scale * nbOM);
		this.width = (int) (Math.sqrt(scale) * this.width);
		//System.out.println("Created a world of " + this.nbMM + " MM, " + this.nbOM + " OM and " + this.width + " size");
	}
	
	public MiorWorld(MiorWorld ref) {
		this.nbMM = ref.nbMM;
		this.nbOM = ref.nbOM;
		this.width = ref.width;
		this.scale = ref.scale;
		//System.out.println("Copied a world of " + this.nbMM + " MM, " + this.nbOM + " OM and " + this.width + " size");
	}
	
	public double getScale() {
		return scale;
	}
	
	public String toString() {
		return "MiorWorld(" + nbMM + "," + nbOM + ")";
	}
	
}
