package mior.model;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

import mcmas.core.MCMEvent;




public class MiorFuture implements Future<MiorSimulation> {
	
	private final MiorSimulation simulation;
	
	public MiorFuture(MiorSimulation simulation) {
		this.simulation = simulation;
	}
	
	@Override
	public MiorSimulation get() throws InterruptedException, ExecutionException {
		MCMEvent.waitFor(simulation.copyEvents);
		return null;
	}
	
	@Override
	public MiorSimulation get(long timeout, TimeUnit unit)
			throws InterruptedException, ExecutionException, TimeoutException {
		throw new UnsupportedOperationException();
	}
	
	@Override
	public boolean cancel(boolean mayInterruptIfRunning) {
		return false;
	}
	
	@Override
	public boolean isCancelled() {
		return false;
	}
	
	@Override
	public boolean isDone() {
		boolean done = true;
		
		for (int i = 0; i < simulation.copyEvents.length; i++) {
			done &= simulation.copyEvents[i].isDone();
		}
		
		return done;
	}
	
}
