package mior.model;


public interface IMiorModel {
	
	public int getStep();
	public MiorWorld getWorld();
	public MiorOM[] getOMList();
	public MiorMM[] getMMList();
	//public int[] getAssociations();
	public boolean isAccessible(int iMM, int iOM);
	public boolean isAccessible(int iMM, int iOM, int iSim);
	
	public void addUpdateListener(IMiorUpdateListener listener);
	public void removeUpdateListener(IMiorUpdateListener listener);
	
	public void setBatchModeEnabled(boolean b);
	public boolean isBatchModeEnabled();
	
	public void setRandomEnabled(boolean b);
	public boolean isRandomEnabled();
	
	public void setBlockSize(int blockSize);
	public int getBlockSize();
	
	public boolean isFinished();
	public int getNbSimulations();
	
	public void reset();
	public void doTopology();
	public void doLive();
	public void doAutoLive();
	
	public void release();
	
}
