package mior.model;

import mcmas.core.MCMChrono;

import java.util.ArrayList;
import java.util.Arrays;


public class DynamicArray {
	
	private int[] array;
	private int length;
	
	public DynamicArray() {
		this.array = new int[1024];
	}
	
	public void set(int index, int value) {
		if (index >= array.length) {
			this.array = Arrays.copyOf(array, index << 1); //nearestPowerOfTwo(index + 1)); 
		}
		
		this.length = Math.max(length, index + 1);
		this.array[index] = value;
	}
	
	public int get(int index) {
		return this.array[index];
	}
	
	public int[] toArray() {
		return Arrays.copyOf(array, length);
	}
	
	private int nearestPowerOfTwo(int n) {
		final int bitsize = Integer.SIZE;
		n--;
		
		for (int i = 1; i <= bitsize >> 1; i <<= 1) {
			n = n | (n >> i);
		}
		
		return n + 1;
	}
	
	public static void main(String[] args) {	
		MCMChrono c = new MCMChrono("ArrayList");
		
		c.start();
		
		ArrayList<Integer> a = new ArrayList<Integer>();
		
		for (int i = 0; i < 10000000; i++) {
			a.add(i);
		}
		
		System.out.println(c.stop());
		
		c.start();
		
		DynamicArray b = new DynamicArray();
		
		for (int i = 0; i < 10000000; i++) {
			b.set(i, i);
		}
		
		System.out.println(c.stop());
	}
	
}
