package mior.controler;

import java.awt.event.ActionEvent;

import javax.swing.SwingWorker;

import mior.model.IMiorModel;

public class TopoAction extends AbstractMiorAction<IMiorModel> {
	
	private static final long serialVersionUID = 1L;

	public TopoAction(IMiorModel model) {
		super(model, "Topo");
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		setEnabled(false);
		new SwingWorker<Void, Void>() {
			
			@Override
			protected Void doInBackground() throws Exception {
				getData().doTopology();
				return null;
			}
			
			@Override
			protected void done() {
				setEnabled(true);
			};
			
		}.execute();
	}

}
