package mior.controler;

import java.awt.event.ActionEvent;

import javax.swing.SwingWorker;

import mior.model.IMiorModel;

public class ResetAction extends AbstractMiorAction<IMiorModel> {
	
	private static final long serialVersionUID = 1L;
	
	public ResetAction(IMiorModel model) {
		super(model, "Reset");
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		setEnabled(false);
		new SwingWorker<Void, Void>() {
			
			@Override
			protected Void doInBackground() throws Exception {
				getData().reset();
				return null;
			}
			
			@Override
			protected void done() {
				setEnabled(true);
			};
			
		}.execute();
	}

}
