package mior.controler;

import java.awt.event.ActionEvent;

import javax.swing.SwingWorker;

import mior.model.IMiorModel;

public class LiveAction extends AbstractMiorAction<IMiorModel> {
	
	private static final long serialVersionUID = 1L;

	public LiveAction(IMiorModel model) {
		super(model, "Live");
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		setEnabled(false);
		new SwingWorker<Void, Void>() {
			
			@Override
			protected Void doInBackground() throws Exception {
				getData().doLive();
				return null;
			}
			
			@Override
			protected void done() {
				setEnabled(true);
			};
			
		}.execute();
	}

}
