package mior.controler;

import java.awt.event.ActionEvent;

import javax.swing.AbstractButton;
import javax.swing.Action;

import mior.model.IMiorModel;

public class ConfigureRandomAction extends AbstractMiorAction<IMiorModel> {

	private static final long serialVersionUID = 1L;

	public ConfigureRandomAction(IMiorModel data) {
		super(data, "Enable randomization");
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		AbstractButton src = (AbstractButton) e.getSource();
		getData().setRandomEnabled(src.isSelected());
	}
	
	@Override
	public Object getValue(String key) {
		if (Action.SELECTED_KEY.equals(key)) {
			return getData().isRandomEnabled();
		} else {
			return super.getValue(key);
		}
	}
	
	@Override
	public void putValue(String key, Object newValue) {
		if (Action.SELECTED_KEY.equals(key)) {
			getData().setRandomEnabled((Boolean) newValue);
		} else {
			super.putValue(key, newValue);
		}
	}
	
}
