package mior;

import java.nio.ByteBuffer;

import mcmas.core.MCMContext;
import mcmas.core.MCMMem;

import org.jocl.struct.Buffers;
import org.jocl.struct.SizeofStruct;
import org.jocl.struct.Struct;

public class StructBuffer<T extends Struct> {
	
	private final T[] data;
	private final ByteBuffer buffer;
	private final long byteSize;
	private final MCMMem mem;
	
	public StructBuffer(MCMContext context, T... data) {
		this.data = data;
		this.buffer = Buffers.allocateBuffer(data);
		Buffers.writeToBuffer(buffer, data);
		this.byteSize = SizeofStruct.sizeof(data[0].getClass());
		this.mem = context.newBuffer().Using(buffer).b();
		//createBuffer(byteSize, OCL.MEM_RW, Pointer.to(buffer));
	}
	
	public T[] getData() {
		return data;
	}
	
	public ByteBuffer getBuffer() {
		return buffer;
	}
	
	public long getByteSize() {
		return byteSize;
	}
	
	public MCMMem getMem() {
		return mem;
	}
	
	public void read() {
		buffer.rewind();
		Buffers.readFromBuffer(buffer, data);
	}
	
	public void write() {
		buffer.rewind();
		Buffers.writeToBuffer(buffer, data);
	}
	
	public void release() {
		mem.release();
	}

}
