package mior;

public class OldMiorKernel {
	
	public final static String topographyKernel = "" +
	    "typedef struct {                                                                       \n" +
	    "    float x;                                                                           \n" +
	    "    float y;                                                                           \n" +
	    "    int carbone;                                                                       \n" +
	    "    int dormance;                                                                      \n" +
	    "} MM;                                                                                  \n" +
	    
	    "typedef struct {                                                                       \n" +
	    "    float x;                                                                           \n" +
	    "    float y;                                                                           \n" +
	    "    int carbone;                                                                       \n" +
	    "} OM;                                                                                  \n" +
	    
	    "typedef struct {                                                                       \n" +
	    "    int nbMM;                                                                          \n" +
	    "    int nbOM;                                                                          \n" +
	    "    int radius;                                                                        \n" +
	    "    float respirationRate;                                                             \n" +
	    "    float growRate;                                                                    \n" +
	    "    float killRate;                                                                    \n" +
	    "    int width;                                                                         \n" +
	    "    int minSize;                                                                       \n" +
	    "} MiorWorld;                                                                           \n" +
	    
	    "kernel void topography(                                                                \n" +
	    "        global MM *mmList,                                                             \n" +
	    "        global OM *omList,                                                             \n" +
	    "        global int *topo,                                                              \n" +
	    "        constant MiorWorld *world) {                                                   \n" +
		"    int iMM = get_global_id(0);                                                              \n" +
		"    int iOM = get_global_id(1);                                                         \n" +
		"    int index = iMM * world->nbOM + iOM;                                                              \n" +
		"    float dx = omList[iOM].x - mmList[iMM].x;     " +
		"    float dy = omList[iOM].y - mmList[iMM].y;                                                            \n" +
		"    float distance = sqrt(dx * dx + dy * dy);                 \n" +
		"    if (distance <= world->radius) {                                                    \n" +
		"       topo[index] = distance;                                                  \n" +
		"    } else {                                                                           \n" +
		"       topo[index] = 0;                                           \n" +
		"    }; //topo[index] = distance;\n" +
		"                                                                                  \n" +
		"}\n";
		
	
}
