package mior;
/*
import java.util.Random;
import java.util.concurrent.ExecutionException;

import javax.swing.JFrame;

import mior.model.IMiorModel;
import mior.view.MiorCanvas;

import org.jocl.Pointer;
import org.jocl.Sizeof;
import ocl.OCL;
import ocl.OCLCommandQueue;
import ocl.OCLContext;
import ocl.OCLEvent;
import ocl.OCLKernel;
import ocl.OCLMem;
import ocl.OCLProgram;

public class MiorSimulation2 implements IMiorModel {
	
	private MiorMM  [] mmList;
	private StructBuffer<MiorMM> mmBuffer;
	
	private MiorOM  [] omList;
	private StructBuffer<MiorOM> omBuffer;
	
	private int     [] associations;
	private long       associationsSize;
	private OCLMem     associationsMem;
	
	private MiorWorld  world;
	private StructBuffer<MiorWorld> worldBuffer;
	
	private OCLContext context;
	private OCLCommandQueue queue;
	
	public MiorSimulation2() {
		initializeOpenCL();
		
		this.world = new MiorWorld();
		this.worldBuffer = new StructBuffer<MiorWorld>(context, world);
		
		this.associations = new int[world.nbMM * world.nbOM];
		this.associationsSize = associations.length * Sizeof.cl_int;
		this.associationsMem = context.createBuffer(associations.length, OCL.INT, OCL.MEM_RW);
		
		initializeMM();
		initializeOM();
		
		computeTopography();
		
		releaseOpenCL();
	}
	
	public void computeTopography() {
		OCLProgram program = context.createProgram(MiorKernel.topographyKernel);
		OCLKernel topographyKernel = program.createKernel("topography");
		
		topographyKernel.setArguments(mmBuffer.getMem(), omBuffer.getMem(), associationsMem, worldBuffer.getMem());
		
		OCLEvent event = queue.enqueueKernel(
				topographyKernel, 2,
				new long[] { 0, 0 },
				new long[] { mmList.length, omList.length },
				new long[] { 1, 1 }
		);
		
		try {
			event.get();
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ExecutionException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		queue.blockingReadBuffer(associationsMem, Pointer.to(associations), 0, associationsSize);
		
		/*
		for (int i = 0; i < world.nbMM; i++) {
			for (int j = 0; j < world.nbOM; j++) {
				//System.out.print(", " + associations[i * world.nbMM + j]);
				double distance = Math.sqrt(Math.pow(mmList[i].x - omList[j].x, 2) + Math.pow(mmList[i].y - omList[j].y, 2));
				
				if (distance <= world.radius) {
					System.out.print(".");
				}
			}
			System.out.println();
		}*/
/*	}
	
	private void initializeMM() {
		Random rand = new Random();
		
		this.mmList = new MiorMM[world.nbMM];
		
		for (int i = 0; i < world.nbMM; i++) {
			mmList[i] = new MiorMM(
					rand.nextInt(world.width),
					rand.nextInt(world.width)
			);
		}
		
		this.mmBuffer = new StructBuffer<MiorMM>(context, mmList);
	}
	private void initializeOM() {
		Random rand = new Random();
		
		this.omList = new MiorOM[world.nbOM];
		
		for (int i = 0; i < world.nbOM; i++) {
			omList[i] = new MiorOM(
					rand.nextInt(world.width),
					rand.nextInt(world.width)
			);
		}
		
		this.omBuffer = new StructBuffer<MiorOM>(context, omList);
	}
	
	private void initializeOpenCL() {
		this.context = new OCLContext();
		this.queue = context.createCommandQueue();
	}
	
	private void releaseOpenCL() {
		associationsMem.release();
		worldBuffer.release();
		mmBuffer.release();
		omBuffer.release();
		queue.release();
		context.release();
	}
	
	@Override
	public MiorOM[] getOMList() {
		return omList;
	}
	
	@Override
	public MiorMM[] getMMList() {
		return mmList;
	}
	
	@Override
	public MiorWorld getWorld() {
		return world;
	}
	
	@Override
	public int[] getAssociations() {
		return associations;
	}
	
	public static void main(String[] args) {
		MiorSimulation2 simu = new MiorSimulation2();
		MiorCanvas canvas = new MiorCanvas(simu);
		
		JFrame frame = new JFrame("Mior CL");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setContentPane(canvas);
		frame.pack();
		frame.setVisible(true);
	}
}
*/