package mcmas.utils;

import java.util.Arrays;
import java.util.Comparator;

/**
 * Partial backport of the new Java SE 7.0 java.utils.Objects class
 * @author glaville
 *
 */
public class Objects7 {
	
	public static boolean equals(Object a, Object b) {
		if (a == null) {
			return (b == null ? true : false);
		} else if (b == null) {
			return false;
		} else {
			return a.equals(b);
		}
	}
	
	public static boolean deepEquals(Object a, Object b) {
		if (a.getClass().isArray() && b.getClass().isArray()) {
			return Arrays.deepEquals((Object[]) a, (Object[]) b);
		} else {
			return equals(a, b);
		}
	}
	
	public static int hashCode(Object o) {
		return (o == null ? 0 : o.hashCode());
	}
	
	public static int hash(Object... values) {
		return Arrays.hashCode(values);
	}
	
	public static String toString(Object obj) {
		return (obj == null ? "null" : obj.toString());
	}
	
	public static String toString(Object obj, String nullDefault) {
		return (obj == null ? nullDefault : obj.toString());
	}
	
	public static <T> int compare(T a, T b, Comparator<? super T> c) {
		return (a == b ? 0 : c.compare(a, b));
	}
	
	public static <T> T requireNonNull(T obj) {
		if (obj == null) throw new NullPointerException();
		return obj;
	}
	
	public static <T> T requireNonNull(T obj, String message) {
		if (obj == null) throw new NullPointerException(message);
		return obj;
	}

}
