package mcmas.utils;

public class IntMatrix extends Matrix {
	
	private int[] storage;
	
	public IntMatrix(int width, int height) {
		super(width, height);
		this.storage = new int[width * height];
	}
	
	public int get(int i) {
		return get(i, 0);
	}
	
	public int get(int x, int y) {
		return storage[offset(x, y)];
	}
	
	public void set(int i, int val) {
		set(i, 0, val);
	}
	
	public void set(int x, int y, int val) {
		storage[offset(x, y)] = val;
	}
	
	public int[] getStorage() {
		return storage;
	}
	
	public String toString() {
		StringBuffer b = new StringBuffer();
		
		for (int i = 0; i < getHeight(); i++) {
			for (int j = 0; j < getWidth(); j++) {
				b.append(String.format("%2d ", get(j, i)));
			}
			
			b.append('\n');
		}
		
		return b.toString();
	}
	
}
