package mcmas.utils;

public class FloatMatrix extends Matrix {
	
	private final float[] storage;
	
	public FloatMatrix(int width, int height) {
		super(width, height);
		this.storage = new float[width * height];
	}
	
	public float get(int i) {
		return get(i, 0);
	}
	
	public float get(int x, int y) {
		return storage[y * getWidth() + x];
	}
	
	public void set(int i, float val) {
		set(i, 0, val);
	}
	
	public void set(int x, int y, float val) {
		storage[y * getWidth() + x] = val;
	}
	
	public float[] getStorage() {
		return storage;
	}
	
}
